// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.email.implementation.models;

import com.azure.communication.email.models.EmailAddress;
import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Recipients of the email.
 */
@Fluent
public final class EmailRecipients implements JsonSerializable<EmailRecipients> {
    /*
     * Email To recipients
     */
    private List<EmailAddress> to;

    /*
     * Email CC recipients
     */
    private List<EmailAddress> cc;

    /*
     * Email BCC recipients
     */
    private List<EmailAddress> bCC;

    /**
     * Creates an instance of EmailRecipients class.
     */
    public EmailRecipients() {
    }

    /**
     * Get the to property: Email To recipients.
     * 
     * @return the to value.
     */
    public List<EmailAddress> getTo() {
        return this.to;
    }

    /**
     * Set the to property: Email To recipients.
     * 
     * @param to the to value to set.
     * @return the EmailRecipients object itself.
     */
    public EmailRecipients setTo(List<EmailAddress> to) {
        this.to = to;
        return this;
    }

    /**
     * Get the cc property: Email CC recipients.
     * 
     * @return the cc value.
     */
    public List<EmailAddress> getCc() {
        return this.cc;
    }

    /**
     * Set the cc property: Email CC recipients.
     * 
     * @param cc the cc value to set.
     * @return the EmailRecipients object itself.
     */
    public EmailRecipients setCc(List<EmailAddress> cc) {
        this.cc = cc;
        return this;
    }

    /**
     * Get the bCC property: Email BCC recipients.
     * 
     * @return the bCC value.
     */
    public List<EmailAddress> getBCC() {
        return this.bCC;
    }

    /**
     * Set the bCC property: Email BCC recipients.
     * 
     * @param bCC the bCC value to set.
     * @return the EmailRecipients object itself.
     */
    public EmailRecipients setBCC(List<EmailAddress> bCC) {
        this.bCC = bCC;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("to", this.to, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("cc", this.cc, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("bcc", this.bCC, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EmailRecipients from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EmailRecipients if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the EmailRecipients.
     */
    public static EmailRecipients fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EmailRecipients deserializedEmailRecipients = new EmailRecipients();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("to".equals(fieldName)) {
                    List<EmailAddress> to = reader.readArray(reader1 -> EmailAddress.fromJson(reader1));
                    deserializedEmailRecipients.to = to;
                } else if ("cc".equals(fieldName)) {
                    List<EmailAddress> cc = reader.readArray(reader1 -> EmailAddress.fromJson(reader1));
                    deserializedEmailRecipients.cc = cc;
                } else if ("bcc".equals(fieldName)) {
                    List<EmailAddress> bCC = reader.readArray(reader1 -> EmailAddress.fromJson(reader1));
                    deserializedEmailRecipients.bCC = bCC;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEmailRecipients;
        });
    }
}
