// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.email.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Content of the email.
 */
@Fluent
public final class EmailContent implements JsonSerializable<EmailContent> {
    /*
     * Subject of the email message
     */
    private final String subject;

    /*
     * Plain text version of the email message.
     */
    private String plainText;

    /*
     * Html version of the email message.
     */
    private String html;

    /**
     * Creates an instance of EmailContent class.
     * 
     * @param subject the subject value to set.
     */
    public EmailContent(String subject) {
        this.subject = subject;
    }

    /**
     * Get the subject property: Subject of the email message.
     * 
     * @return the subject value.
     */
    public String getSubject() {
        return this.subject;
    }

    /**
     * Get the plainText property: Plain text version of the email message.
     * 
     * @return the plainText value.
     */
    public String getPlainText() {
        return this.plainText;
    }

    /**
     * Set the plainText property: Plain text version of the email message.
     * 
     * @param plainText the plainText value to set.
     * @return the EmailContent object itself.
     */
    public EmailContent setPlainText(String plainText) {
        this.plainText = plainText;
        return this;
    }

    /**
     * Get the html property: Html version of the email message.
     * 
     * @return the html value.
     */
    public String getHtml() {
        return this.html;
    }

    /**
     * Set the html property: Html version of the email message.
     * 
     * @param html the html value to set.
     * @return the EmailContent object itself.
     */
    public EmailContent setHtml(String html) {
        this.html = html;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("subject", this.subject);
        jsonWriter.writeStringField("plainText", this.plainText);
        jsonWriter.writeStringField("html", this.html);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EmailContent from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EmailContent if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the EmailContent.
     */
    public static EmailContent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean subjectFound = false;
            String subject = null;
            String plainText = null;
            String html = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("subject".equals(fieldName)) {
                    subject = reader.getString();
                    subjectFound = true;
                } else if ("plainText".equals(fieldName)) {
                    plainText = reader.getString();
                } else if ("html".equals(fieldName)) {
                    html = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            if (subjectFound) {
                EmailContent deserializedEmailContent = new EmailContent(subject);
                deserializedEmailContent.plainText = plainText;
                deserializedEmailContent.html = html;

                return deserializedEmailContent;
            }
            throw new IllegalStateException("Missing required property: subject");
        });
    }
}
