/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.identity.implementation;

import com.azure.communication.identity.implementation.CommunicationIdentityClientImpl;
import com.azure.communication.identity.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.identity.implementation.models.CommunicationIdentityAccessToken;
import com.azure.communication.identity.implementation.models.CommunicationIdentityAccessTokenRequest;
import com.azure.communication.identity.implementation.models.CommunicationIdentityAccessTokenResult;
import com.azure.communication.identity.implementation.models.CommunicationIdentityCreateRequest;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import reactor.core.publisher.Mono;

public final class CommunicationIdentityImpl {
    private final CommunicationIdentityService service;
    private final CommunicationIdentityClientImpl client;

    CommunicationIdentityImpl(CommunicationIdentityClientImpl client) {
        this.service = (CommunicationIdentityService)RestProxy.create(CommunicationIdentityService.class, (HttpPipeline)client.getHttpPipeline());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CommunicationIdentityAccessTokenResult>> createWithResponseAsync(CommunicationIdentityCreateRequest body) {
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getApiVersion(), body, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CommunicationIdentityAccessTokenResult>> createWithResponseAsync(CommunicationIdentityCreateRequest body, Context context) {
        return this.service.create(this.client.getEndpoint(), this.client.getApiVersion(), body, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CommunicationIdentityAccessTokenResult> createAsync(CommunicationIdentityCreateRequest body) {
        return this.createWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CommunicationIdentityAccessTokenResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CommunicationIdentityAccessTokenResult> createAsync(CommunicationIdentityCreateRequest body, Context context) {
        return this.createWithResponseAsync(body, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CommunicationIdentityAccessTokenResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CommunicationIdentityAccessTokenResult create(CommunicationIdentityCreateRequest body) {
        return (CommunicationIdentityAccessTokenResult)this.createAsync(body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CommunicationIdentityAccessTokenResult create(CommunicationIdentityCreateRequest body, Context context) {
        return (CommunicationIdentityAccessTokenResult)this.createAsync(body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String id) {
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), id, this.client.getApiVersion(), (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String id, Context context) {
        return this.service.delete(this.client.getEndpoint(), id, this.client.getApiVersion(), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String id) {
        return this.deleteWithResponseAsync(id).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String id, Context context) {
        return this.deleteWithResponseAsync(id, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String id) {
        this.deleteAsync(id).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String id, Context context) {
        this.deleteAsync(id, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> revokeAccessTokensWithResponseAsync(String id) {
        return FluxUtil.withContext(context -> this.service.revokeAccessTokens(this.client.getEndpoint(), id, this.client.getApiVersion(), (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> revokeAccessTokensWithResponseAsync(String id, Context context) {
        return this.service.revokeAccessTokens(this.client.getEndpoint(), id, this.client.getApiVersion(), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> revokeAccessTokensAsync(String id) {
        return this.revokeAccessTokensWithResponseAsync(id).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> revokeAccessTokensAsync(String id, Context context) {
        return this.revokeAccessTokensWithResponseAsync(id, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void revokeAccessTokens(String id) {
        this.revokeAccessTokensAsync(id).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void revokeAccessTokens(String id, Context context) {
        this.revokeAccessTokensAsync(id, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CommunicationIdentityAccessToken>> issueAccessTokenWithResponseAsync(String id, CommunicationIdentityAccessTokenRequest body) {
        return FluxUtil.withContext(context -> this.service.issueAccessToken(this.client.getEndpoint(), id, this.client.getApiVersion(), body, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CommunicationIdentityAccessToken>> issueAccessTokenWithResponseAsync(String id, CommunicationIdentityAccessTokenRequest body, Context context) {
        return this.service.issueAccessToken(this.client.getEndpoint(), id, this.client.getApiVersion(), body, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CommunicationIdentityAccessToken> issueAccessTokenAsync(String id, CommunicationIdentityAccessTokenRequest body) {
        return this.issueAccessTokenWithResponseAsync(id, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CommunicationIdentityAccessToken)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CommunicationIdentityAccessToken> issueAccessTokenAsync(String id, CommunicationIdentityAccessTokenRequest body, Context context) {
        return this.issueAccessTokenWithResponseAsync(id, body, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CommunicationIdentityAccessToken)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CommunicationIdentityAccessToken issueAccessToken(String id, CommunicationIdentityAccessTokenRequest body) {
        return (CommunicationIdentityAccessToken)this.issueAccessTokenAsync(id, body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CommunicationIdentityAccessToken issueAccessToken(String id, CommunicationIdentityAccessTokenRequest body, Context context) {
        return (CommunicationIdentityAccessToken)this.issueAccessTokenAsync(id, body, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="CommunicationIdentity")
    private static interface CommunicationIdentityService {
        @Post(value="/identities")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<CommunicationIdentityAccessTokenResult>> create(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") CommunicationIdentityCreateRequest var3, Context var4);

        @Delete(value="/identities/{id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> delete(@HostParam(value="endpoint") String var1, @PathParam(value="id") String var2, @QueryParam(value="api-version") String var3, Context var4);

        @Post(value="/identities/{id}/:revokeAccessTokens")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> revokeAccessTokens(@HostParam(value="endpoint") String var1, @PathParam(value="id") String var2, @QueryParam(value="api-version") String var3, Context var4);

        @Post(value="/identities/{id}/:issueAccessToken")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<CommunicationIdentityAccessToken>> issueAccessToken(@HostParam(value="endpoint") String var1, @PathParam(value="id") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CommunicationIdentityAccessTokenRequest var4, Context var5);
    }
}

