/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.identity;

import com.azure.communication.common.CommunicationUserIdentifier;
import com.azure.communication.identity.CommunicationIdentityClientBuilder;
import com.azure.communication.identity.implementation.CommunicationIdentitiesImpl;
import com.azure.communication.identity.implementation.CommunicationIdentityClientImpl;
import com.azure.communication.identity.implementation.models.CommunicationIdentityAccessToken;
import com.azure.communication.identity.implementation.models.CommunicationIdentityAccessTokenRequest;
import com.azure.communication.identity.implementation.models.CommunicationIdentityAccessTokenResult;
import com.azure.communication.identity.implementation.models.CommunicationIdentityCreateRequest;
import com.azure.communication.identity.implementation.models.TeamsUserAccessTokenRequest;
import com.azure.communication.identity.models.CommunicationTokenScope;
import com.azure.communication.identity.models.CommunicationUserIdentifierAndToken;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AccessToken;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@ServiceClient(builder=CommunicationIdentityClientBuilder.class, isAsync=false)
public final class CommunicationIdentityClient {
    private final CommunicationIdentitiesImpl client;
    private final ClientLogger logger = new ClientLogger(CommunicationIdentityClient.class);

    CommunicationIdentityClient(CommunicationIdentityClientImpl communicationIdentityClient) {
        this.client = communicationIdentityClient.getCommunicationIdentities();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CommunicationUserIdentifier createUser() {
        CommunicationIdentityAccessTokenResult result = this.client.create(new CommunicationIdentityCreateRequest());
        return new CommunicationUserIdentifier(result.getIdentity().getId());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CommunicationUserIdentifier> createUserWithResponse(Context context) {
        Response response = (Response)this.client.createWithResponseAsync(new CommunicationIdentityCreateRequest(), context = context == null ? Context.NONE : context).block();
        if (response == null || response.getValue() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Service failed to return a response or expected value."));
        }
        String id = ((CommunicationIdentityAccessTokenResult)response.getValue()).getIdentity().getId();
        return new SimpleResponse(response, (Object)new CommunicationUserIdentifier(id));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CommunicationUserIdentifierAndToken createUserAndToken(Iterable<CommunicationTokenScope> scopes) {
        Objects.requireNonNull(scopes);
        List<CommunicationTokenScope> scopesInput = StreamSupport.stream(scopes.spliterator(), false).collect(Collectors.toList());
        CommunicationIdentityAccessTokenResult result = this.client.create(new CommunicationIdentityCreateRequest().setCreateTokenWithScopes(scopesInput));
        return this.userWithAccessTokenResultConverter(result);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CommunicationUserIdentifierAndToken> createUserAndTokenWithResponse(Iterable<CommunicationTokenScope> scopes, Context context) {
        Objects.requireNonNull(scopes);
        context = context == null ? Context.NONE : context;
        List<CommunicationTokenScope> scopesInput = StreamSupport.stream(scopes.spliterator(), false).collect(Collectors.toList());
        Response response = (Response)this.client.createWithResponseAsync(new CommunicationIdentityCreateRequest().setCreateTokenWithScopes(scopesInput), context).block();
        if (response == null || response.getValue() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Service failed to return a response or expected value."));
        }
        return new SimpleResponse(response, (Object)this.userWithAccessTokenResultConverter((CommunicationIdentityAccessTokenResult)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteUser(CommunicationUserIdentifier communicationUser) {
        Objects.requireNonNull(communicationUser);
        this.client.deleteAsync(communicationUser.getId()).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteUserWithResponse(CommunicationUserIdentifier communicationUser, Context context) {
        Objects.requireNonNull(communicationUser);
        context = context == null ? Context.NONE : context;
        return (Response)this.client.deleteWithResponseAsync(communicationUser.getId(), context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void revokeTokens(CommunicationUserIdentifier communicationUser) {
        Objects.requireNonNull(communicationUser);
        this.client.revokeAccessTokensAsync(communicationUser.getId()).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> revokeTokensWithResponse(CommunicationUserIdentifier communicationUser, Context context) {
        Objects.requireNonNull(communicationUser);
        context = context == null ? Context.NONE : context;
        return (Response)this.client.revokeAccessTokensWithResponseAsync(communicationUser.getId(), context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AccessToken getToken(CommunicationUserIdentifier communicationUser, Iterable<CommunicationTokenScope> scopes) {
        Objects.requireNonNull(communicationUser);
        Objects.requireNonNull(scopes);
        List<CommunicationTokenScope> scopesInput = StreamSupport.stream(scopes.spliterator(), false).collect(Collectors.toList());
        CommunicationIdentityAccessToken rawToken = this.client.issueAccessToken(communicationUser.getId(), new CommunicationIdentityAccessTokenRequest().setScopes(scopesInput));
        return new AccessToken(rawToken.getToken(), rawToken.getExpiresOn());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AccessToken> getTokenWithResponse(CommunicationUserIdentifier communicationUser, Iterable<CommunicationTokenScope> scopes, Context context) {
        Objects.requireNonNull(communicationUser);
        Objects.requireNonNull(scopes);
        context = context == null ? Context.NONE : context;
        List<CommunicationTokenScope> scopesInput = StreamSupport.stream(scopes.spliterator(), false).collect(Collectors.toList());
        Response response = (Response)this.client.issueAccessTokenWithResponseAsync(communicationUser.getId(), new CommunicationIdentityAccessTokenRequest().setScopes(scopesInput), context).block();
        if (response == null || response.getValue() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Service failed to return a response or expected value."));
        }
        return new SimpleResponse(response, (Object)new AccessToken(((CommunicationIdentityAccessToken)response.getValue()).getToken(), ((CommunicationIdentityAccessToken)response.getValue()).getExpiresOn()));
    }

    private CommunicationUserIdentifierAndToken userWithAccessTokenResultConverter(CommunicationIdentityAccessTokenResult identityAccessTokenResult) {
        CommunicationUserIdentifier user = new CommunicationUserIdentifier(identityAccessTokenResult.getIdentity().getId());
        AccessToken token = new AccessToken(identityAccessTokenResult.getAccessToken().getToken(), identityAccessTokenResult.getAccessToken().getExpiresOn());
        return new CommunicationUserIdentifierAndToken(user, token);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AccessToken getTokenForTeamsUser(String teamsUserAadToken) {
        TeamsUserAccessTokenRequest requestBody = new TeamsUserAccessTokenRequest();
        requestBody.setToken(teamsUserAadToken);
        CommunicationIdentityAccessToken rawToken = this.client.exchangeTeamsUserAccessToken(requestBody);
        return new AccessToken(rawToken.getToken(), rawToken.getExpiresOn());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AccessToken> getTokenForTeamsUserWithResponse(String teamsUserAadToken, Context context) {
        context = context == null ? Context.NONE : context;
        TeamsUserAccessTokenRequest requestBody = new TeamsUserAccessTokenRequest();
        requestBody.setToken(teamsUserAadToken);
        Response response = (Response)this.client.exchangeTeamsUserAccessTokenWithResponseAsync(requestBody, context).block();
        if (response == null || response.getValue() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Service failed to return a response or expected value."));
        }
        return new SimpleResponse(response, (Object)new AccessToken(((CommunicationIdentityAccessToken)response.getValue()).getToken(), ((CommunicationIdentityAccessToken)response.getValue()).getExpiresOn()));
    }
}

