/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.identity;

import com.azure.communication.common.CommunicationUserIdentifier;
import com.azure.communication.identity.CommunicationIdentityClientBuilder;
import com.azure.communication.identity.CommunicationIdentityClientUtils;
import com.azure.communication.identity.implementation.CommunicationIdentitiesImpl;
import com.azure.communication.identity.implementation.CommunicationIdentityClientImpl;
import com.azure.communication.identity.implementation.models.CommunicationIdentityAccessToken;
import com.azure.communication.identity.implementation.models.CommunicationIdentityAccessTokenRequest;
import com.azure.communication.identity.implementation.models.CommunicationIdentityAccessTokenResult;
import com.azure.communication.identity.implementation.models.CommunicationIdentityCreateRequest;
import com.azure.communication.identity.models.CommunicationTokenScope;
import com.azure.communication.identity.models.CommunicationUserIdentifierAndToken;
import com.azure.communication.identity.models.GetTokenForTeamsUserOptions;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AccessToken;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;
import java.util.Objects;

@ServiceClient(builder=CommunicationIdentityClientBuilder.class, isAsync=false)
public final class CommunicationIdentityClient {
    private final CommunicationIdentitiesImpl client;
    private final ClientLogger logger = new ClientLogger(CommunicationIdentityClient.class);

    CommunicationIdentityClient(CommunicationIdentityClientImpl communicationIdentityClient) {
        this.client = communicationIdentityClient.getCommunicationIdentities();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CommunicationUserIdentifier createUser() {
        CommunicationIdentityAccessTokenResult result = this.client.create(new CommunicationIdentityCreateRequest());
        return new CommunicationUserIdentifier(result.getIdentity().getId());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CommunicationUserIdentifier> createUserWithResponse(Context context) {
        Response response = (Response)this.client.createWithResponseAsync(new CommunicationIdentityCreateRequest(), context = context == null ? Context.NONE : context).block();
        if (response == null || response.getValue() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Service failed to return a response or expected value."));
        }
        String id = ((CommunicationIdentityAccessTokenResult)response.getValue()).getIdentity().getId();
        return new SimpleResponse(response, (Object)new CommunicationUserIdentifier(id));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CommunicationUserIdentifierAndToken createUserAndToken(Iterable<CommunicationTokenScope> scopes, Duration tokenExpiresIn) {
        Objects.requireNonNull(scopes);
        CommunicationIdentityCreateRequest communicationIdentityCreateRequest = CommunicationIdentityClientUtils.createCommunicationIdentityCreateRequest(scopes, tokenExpiresIn, this.logger);
        CommunicationIdentityAccessTokenResult result = this.client.create(communicationIdentityCreateRequest);
        return this.userWithAccessTokenResultConverter(result);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CommunicationUserIdentifierAndToken createUserAndToken(Iterable<CommunicationTokenScope> scopes) {
        return this.createUserAndToken(scopes, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CommunicationUserIdentifierAndToken> createUserAndTokenWithResponse(Iterable<CommunicationTokenScope> scopes, Duration tokenExpiresIn, Context context) {
        Objects.requireNonNull(scopes);
        context = context == null ? Context.NONE : context;
        CommunicationIdentityCreateRequest communicationIdentityCreateRequest = CommunicationIdentityClientUtils.createCommunicationIdentityCreateRequest(scopes, tokenExpiresIn, this.logger);
        Response response = (Response)this.client.createWithResponseAsync(communicationIdentityCreateRequest, context).block();
        if (response == null || response.getValue() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Service failed to return a response or expected value."));
        }
        return new SimpleResponse(response, (Object)this.userWithAccessTokenResultConverter((CommunicationIdentityAccessTokenResult)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CommunicationUserIdentifierAndToken> createUserAndTokenWithResponse(Iterable<CommunicationTokenScope> scopes, Context context) {
        return this.createUserAndTokenWithResponse(scopes, null, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteUser(CommunicationUserIdentifier communicationUser) {
        Objects.requireNonNull(communicationUser);
        this.client.deleteAsync(communicationUser.getId()).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteUserWithResponse(CommunicationUserIdentifier communicationUser, Context context) {
        Objects.requireNonNull(communicationUser);
        context = context == null ? Context.NONE : context;
        return (Response)this.client.deleteWithResponseAsync(communicationUser.getId(), context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void revokeTokens(CommunicationUserIdentifier communicationUser) {
        Objects.requireNonNull(communicationUser);
        this.client.revokeAccessTokensAsync(communicationUser.getId()).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> revokeTokensWithResponse(CommunicationUserIdentifier communicationUser, Context context) {
        Objects.requireNonNull(communicationUser);
        context = context == null ? Context.NONE : context;
        return (Response)this.client.revokeAccessTokensWithResponseAsync(communicationUser.getId(), context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AccessToken getToken(CommunicationUserIdentifier communicationUser, Iterable<CommunicationTokenScope> scopes, Duration tokenExpiresIn) {
        Objects.requireNonNull(communicationUser);
        Objects.requireNonNull(scopes);
        CommunicationIdentityAccessTokenRequest tokenRequest = CommunicationIdentityClientUtils.createCommunicationIdentityAccessTokenRequest(scopes, tokenExpiresIn, this.logger);
        CommunicationIdentityAccessToken rawToken = this.client.issueAccessToken(communicationUser.getId(), tokenRequest);
        return new AccessToken(rawToken.getToken(), rawToken.getExpiresOn());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AccessToken getToken(CommunicationUserIdentifier communicationUser, Iterable<CommunicationTokenScope> scopes) {
        return this.getToken(communicationUser, scopes, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AccessToken> getTokenWithResponse(CommunicationUserIdentifier communicationUser, Iterable<CommunicationTokenScope> scopes, Duration tokenExpiresIn, Context context) {
        Objects.requireNonNull(communicationUser);
        Objects.requireNonNull(scopes);
        context = context == null ? Context.NONE : context;
        CommunicationIdentityAccessTokenRequest tokenRequest = CommunicationIdentityClientUtils.createCommunicationIdentityAccessTokenRequest(scopes, tokenExpiresIn, this.logger);
        Response response = (Response)this.client.issueAccessTokenWithResponseAsync(communicationUser.getId(), tokenRequest, context).block();
        if (response == null || response.getValue() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Service failed to return a response or expected value."));
        }
        return new SimpleResponse(response, (Object)new AccessToken(((CommunicationIdentityAccessToken)response.getValue()).getToken(), ((CommunicationIdentityAccessToken)response.getValue()).getExpiresOn()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AccessToken> getTokenWithResponse(CommunicationUserIdentifier communicationUser, Iterable<CommunicationTokenScope> scopes, Context context) {
        return this.getTokenWithResponse(communicationUser, scopes, null, context);
    }

    private CommunicationUserIdentifierAndToken userWithAccessTokenResultConverter(CommunicationIdentityAccessTokenResult identityAccessTokenResult) {
        CommunicationUserIdentifier user = new CommunicationUserIdentifier(identityAccessTokenResult.getIdentity().getId());
        AccessToken token = new AccessToken(identityAccessTokenResult.getAccessToken().getToken(), identityAccessTokenResult.getAccessToken().getExpiresOn());
        return new CommunicationUserIdentifierAndToken(user, token);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AccessToken getTokenForTeamsUser(GetTokenForTeamsUserOptions options) {
        CommunicationIdentityAccessToken rawToken = this.client.exchangeTeamsUserAccessToken(options);
        return new AccessToken(rawToken.getToken(), rawToken.getExpiresOn());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AccessToken> getTokenForTeamsUserWithResponse(GetTokenForTeamsUserOptions options, Context context) {
        Response response = (Response)this.client.exchangeTeamsUserAccessTokenWithResponseAsync(options, context = context == null ? Context.NONE : context).block();
        if (response == null || response.getValue() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Service failed to return a response or expected value."));
        }
        return new SimpleResponse(response, (Object)new AccessToken(((CommunicationIdentityAccessToken)response.getValue()).getToken(), ((CommunicationIdentityAccessToken)response.getValue()).getExpiresOn()));
    }
}

