/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.identity.implementation;

import com.azure.communication.identity.implementation.CommunicationIdentityClientImpl;
import com.azure.communication.identity.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.identity.implementation.models.CommunicationIdentityAccessToken;
import com.azure.communication.identity.implementation.models.CommunicationIdentityAccessTokenRequest;
import com.azure.communication.identity.implementation.models.CommunicationIdentityAccessTokenResult;
import com.azure.communication.identity.implementation.models.CommunicationIdentityCreateRequest;
import com.azure.communication.identity.models.GetTokenForTeamsUserOptions;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class CommunicationIdentitiesImpl {
    private final CommunicationIdentitiesService service;
    private final CommunicationIdentityClientImpl client;

    CommunicationIdentitiesImpl(CommunicationIdentityClientImpl client) {
        this.service = (CommunicationIdentitiesService)RestProxy.create(CommunicationIdentitiesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CommunicationIdentityAccessTokenResult>> createWithResponseAsync(CommunicationIdentityCreateRequest body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getApiVersion(), body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CommunicationIdentityAccessTokenResult>> createWithResponseAsync(CommunicationIdentityCreateRequest body, Context context) {
        String accept = "application/json";
        return this.service.create(this.client.getEndpoint(), this.client.getApiVersion(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CommunicationIdentityAccessTokenResult> createAsync(CommunicationIdentityCreateRequest body) {
        return this.createWithResponseAsync(body).flatMap(res -> Mono.justOrEmpty((Object)((CommunicationIdentityAccessTokenResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CommunicationIdentityAccessTokenResult> createAsync(CommunicationIdentityCreateRequest body, Context context) {
        return this.createWithResponseAsync(body, context).flatMap(res -> Mono.justOrEmpty((Object)((CommunicationIdentityAccessTokenResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CommunicationIdentityAccessTokenResult create(CommunicationIdentityCreateRequest body) {
        return (CommunicationIdentityAccessTokenResult)this.createAsync(body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CommunicationIdentityAccessTokenResult> createWithResponse(CommunicationIdentityCreateRequest body, Context context) {
        return (Response)this.createWithResponseAsync(body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String id) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), id, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String id, Context context) {
        String accept = "application/json";
        return this.service.delete(this.client.getEndpoint(), id, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String id) {
        return this.deleteWithResponseAsync(id).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String id, Context context) {
        return this.deleteWithResponseAsync(id, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String id) {
        this.deleteAsync(id).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String id, Context context) {
        return (Response)this.deleteWithResponseAsync(id, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> revokeAccessTokensWithResponseAsync(String id) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.revokeAccessTokens(this.client.getEndpoint(), id, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> revokeAccessTokensWithResponseAsync(String id, Context context) {
        String accept = "application/json";
        return this.service.revokeAccessTokens(this.client.getEndpoint(), id, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> revokeAccessTokensAsync(String id) {
        return this.revokeAccessTokensWithResponseAsync(id).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> revokeAccessTokensAsync(String id, Context context) {
        return this.revokeAccessTokensWithResponseAsync(id, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void revokeAccessTokens(String id) {
        this.revokeAccessTokensAsync(id).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> revokeAccessTokensWithResponse(String id, Context context) {
        return (Response)this.revokeAccessTokensWithResponseAsync(id, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CommunicationIdentityAccessToken>> exchangeTeamsUserAccessTokenWithResponseAsync(GetTokenForTeamsUserOptions body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.exchangeTeamsUserAccessToken(this.client.getEndpoint(), this.client.getApiVersion(), body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CommunicationIdentityAccessToken>> exchangeTeamsUserAccessTokenWithResponseAsync(GetTokenForTeamsUserOptions body, Context context) {
        String accept = "application/json";
        return this.service.exchangeTeamsUserAccessToken(this.client.getEndpoint(), this.client.getApiVersion(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CommunicationIdentityAccessToken> exchangeTeamsUserAccessTokenAsync(GetTokenForTeamsUserOptions body) {
        return this.exchangeTeamsUserAccessTokenWithResponseAsync(body).flatMap(res -> Mono.justOrEmpty((Object)((CommunicationIdentityAccessToken)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CommunicationIdentityAccessToken> exchangeTeamsUserAccessTokenAsync(GetTokenForTeamsUserOptions body, Context context) {
        return this.exchangeTeamsUserAccessTokenWithResponseAsync(body, context).flatMap(res -> Mono.justOrEmpty((Object)((CommunicationIdentityAccessToken)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CommunicationIdentityAccessToken exchangeTeamsUserAccessToken(GetTokenForTeamsUserOptions body) {
        return (CommunicationIdentityAccessToken)this.exchangeTeamsUserAccessTokenAsync(body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CommunicationIdentityAccessToken> exchangeTeamsUserAccessTokenWithResponse(GetTokenForTeamsUserOptions body, Context context) {
        return (Response)this.exchangeTeamsUserAccessTokenWithResponseAsync(body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CommunicationIdentityAccessToken>> issueAccessTokenWithResponseAsync(String id, CommunicationIdentityAccessTokenRequest body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.issueAccessToken(this.client.getEndpoint(), id, this.client.getApiVersion(), body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CommunicationIdentityAccessToken>> issueAccessTokenWithResponseAsync(String id, CommunicationIdentityAccessTokenRequest body, Context context) {
        String accept = "application/json";
        return this.service.issueAccessToken(this.client.getEndpoint(), id, this.client.getApiVersion(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CommunicationIdentityAccessToken> issueAccessTokenAsync(String id, CommunicationIdentityAccessTokenRequest body) {
        return this.issueAccessTokenWithResponseAsync(id, body).flatMap(res -> Mono.justOrEmpty((Object)((CommunicationIdentityAccessToken)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CommunicationIdentityAccessToken> issueAccessTokenAsync(String id, CommunicationIdentityAccessTokenRequest body, Context context) {
        return this.issueAccessTokenWithResponseAsync(id, body, context).flatMap(res -> Mono.justOrEmpty((Object)((CommunicationIdentityAccessToken)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CommunicationIdentityAccessToken issueAccessToken(String id, CommunicationIdentityAccessTokenRequest body) {
        return (CommunicationIdentityAccessToken)this.issueAccessTokenAsync(id, body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CommunicationIdentityAccessToken> issueAccessTokenWithResponse(String id, CommunicationIdentityAccessTokenRequest body, Context context) {
        return (Response)this.issueAccessTokenWithResponseAsync(id, body, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="CommunicationIdentit")
    public static interface CommunicationIdentitiesService {
        @Post(value="/identities")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<CommunicationIdentityAccessTokenResult>> create(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") CommunicationIdentityCreateRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/identities/{id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> delete(@HostParam(value="endpoint") String var1, @PathParam(value="id") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/identities/{id}/:revokeAccessTokens")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> revokeAccessTokens(@HostParam(value="endpoint") String var1, @PathParam(value="id") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/teamsUser/:exchangeAccessToken")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<CommunicationIdentityAccessToken>> exchangeTeamsUserAccessToken(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") GetTokenForTeamsUserOptions var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/identities/{id}/:issueAccessToken")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<CommunicationIdentityAccessToken>> issueAccessToken(@HostParam(value="endpoint") String var1, @PathParam(value="id") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CommunicationIdentityAccessTokenRequest var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

