// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.identity.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** An access token. */
@Fluent
public final class CommunicationIdentityAccessToken {
    /*
     * The access token issued for the identity.
     */
    @JsonProperty(value = "token", required = true)
    private String token;

    /*
     * The expiry time of the token.
     */
    @JsonProperty(value = "expiresOn", required = true)
    private OffsetDateTime expiresOn;

    /**
     * Get the token property: The access token issued for the identity.
     *
     * @return the token value.
     */
    public String getToken() {
        return this.token;
    }

    /**
     * Set the token property: The access token issued for the identity.
     *
     * @param token the token value to set.
     * @return the CommunicationIdentityAccessToken object itself.
     */
    public CommunicationIdentityAccessToken setToken(String token) {
        this.token = token;
        return this;
    }

    /**
     * Get the expiresOn property: The expiry time of the token.
     *
     * @return the expiresOn value.
     */
    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    /**
     * Set the expiresOn property: The expiry time of the token.
     *
     * @param expiresOn the expiresOn value to set.
     * @return the CommunicationIdentityAccessToken object itself.
     */
    public CommunicationIdentityAccessToken setExpiresOn(OffsetDateTime expiresOn) {
        this.expiresOn = expiresOn;
        return this;
    }
}
