// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.identity.implementation.models;

import com.azure.communication.identity.models.CommunicationTokenScope;
import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The CommunicationIdentityAccessTokenRequest model. */
@Fluent
public final class CommunicationIdentityAccessTokenRequest {
    /*
     * List of scopes attached to the token.
     */
    @JsonProperty(value = "scopes", required = true)
    private List<CommunicationTokenScope> scopes;

    /*
     * Optional custom validity period of the token within [60,1440] minutes
     * range. If not provided, the default value of 1440 minutes (24 hours)
     * will be used.
     */
    @JsonProperty(value = "expiresInMinutes")
    private Integer expiresInMinutes;

    /**
     * Get the scopes property: List of scopes attached to the token.
     *
     * @return the scopes value.
     */
    public List<CommunicationTokenScope> getScopes() {
        return this.scopes;
    }

    /**
     * Set the scopes property: List of scopes attached to the token.
     *
     * @param scopes the scopes value to set.
     * @return the CommunicationIdentityAccessTokenRequest object itself.
     */
    public CommunicationIdentityAccessTokenRequest setScopes(List<CommunicationTokenScope> scopes) {
        this.scopes = scopes;
        return this;
    }

    /**
     * Get the expiresInMinutes property: Optional custom validity period of the token within [60,1440] minutes range.
     * If not provided, the default value of 1440 minutes (24 hours) will be used.
     *
     * @return the expiresInMinutes value.
     */
    public Integer getExpiresInMinutes() {
        return this.expiresInMinutes;
    }

    /**
     * Set the expiresInMinutes property: Optional custom validity period of the token within [60,1440] minutes range.
     * If not provided, the default value of 1440 minutes (24 hours) will be used.
     *
     * @param expiresInMinutes the expiresInMinutes value to set.
     * @return the CommunicationIdentityAccessTokenRequest object itself.
     */
    public CommunicationIdentityAccessTokenRequest setExpiresInMinutes(Integer expiresInMinutes) {
        this.expiresInMinutes = expiresInMinutes;
        return this;
    }
}
