// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.identity.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** List of scopes for an access token. */
public final class CommunicationTokenScope extends ExpandableStringEnum<CommunicationTokenScope> {
    /** Static value chat for CommunicationTokenScope. */
    public static final CommunicationTokenScope CHAT = fromString("chat");

    /** Static value voip for CommunicationTokenScope. */
    public static final CommunicationTokenScope VOIP = fromString("voip");

    /**
     * Creates a new instance of CommunicationTokenScope value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public CommunicationTokenScope() {}

    /**
     * Creates or finds a CommunicationTokenScope from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding CommunicationTokenScope.
     */
    @JsonCreator
    public static CommunicationTokenScope fromString(String name) {
        return fromString(name, CommunicationTokenScope.class);
    }

    /**
     * Gets known CommunicationTokenScope values.
     *
     * @return known CommunicationTokenScope values.
     */
    public static Collection<CommunicationTokenScope> values() {
        return values(CommunicationTokenScope.class);
    }
}
