/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.identity;

import com.azure.communication.common.CommunicationUserIdentifier;
import com.azure.communication.identity.CommunicationIdentityClientBuilder;
import com.azure.communication.identity.CommunicationIdentityClientUtils;
import com.azure.communication.identity.implementation.CommunicationIdentitiesImpl;
import com.azure.communication.identity.implementation.CommunicationIdentityClientImpl;
import com.azure.communication.identity.implementation.converters.IdentityErrorConverter;
import com.azure.communication.identity.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.identity.implementation.models.CommunicationIdentityAccessToken;
import com.azure.communication.identity.implementation.models.CommunicationIdentityAccessTokenRequest;
import com.azure.communication.identity.implementation.models.CommunicationIdentityAccessTokenResult;
import com.azure.communication.identity.implementation.models.CommunicationIdentityCreateRequest;
import com.azure.communication.identity.models.CommunicationTokenScope;
import com.azure.communication.identity.models.CommunicationUserIdentifierAndToken;
import com.azure.communication.identity.models.GetTokenForTeamsUserOptions;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AccessToken;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;
import java.util.Objects;
import reactor.core.publisher.Mono;

@ServiceClient(builder=CommunicationIdentityClientBuilder.class, isAsync=true)
public final class CommunicationIdentityAsyncClient {
    private final CommunicationIdentitiesImpl client;
    private final ClientLogger logger = new ClientLogger(CommunicationIdentityAsyncClient.class);

    CommunicationIdentityAsyncClient(CommunicationIdentityClientImpl communicationIdentityServiceClient) {
        this.client = communicationIdentityServiceClient.getCommunicationIdentities();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CommunicationUserIdentifier> createUser() {
        try {
            return this.client.createAsync(new CommunicationIdentityCreateRequest()).onErrorMap(CommunicationErrorResponseException.class, IdentityErrorConverter::translateException).flatMap(result -> Mono.just((Object)new CommunicationUserIdentifier(result.getIdentity().getId())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CommunicationUserIdentifier>> createUserWithResponse() {
        try {
            return this.client.createWithResponseAsync(new CommunicationIdentityCreateRequest()).onErrorMap(CommunicationErrorResponseException.class, IdentityErrorConverter::translateException).flatMap(response -> {
                String id = ((CommunicationIdentityAccessTokenResult)response.getValue()).getIdentity().getId();
                return Mono.just((Object)new SimpleResponse(response, (Object)new CommunicationUserIdentifier(id)));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CommunicationUserIdentifierAndToken> createUserAndToken(Iterable<CommunicationTokenScope> scopes, Duration tokenExpiresIn) {
        try {
            Objects.requireNonNull(scopes);
            CommunicationIdentityCreateRequest communicationIdentityCreateRequest = CommunicationIdentityClientUtils.createCommunicationIdentityCreateRequest(scopes, tokenExpiresIn, this.logger);
            return this.client.createAsync(communicationIdentityCreateRequest).onErrorMap(CommunicationErrorResponseException.class, IdentityErrorConverter::translateException).flatMap(result -> Mono.just((Object)this.userWithAccessTokenResultConverter((CommunicationIdentityAccessTokenResult)result)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CommunicationUserIdentifierAndToken> createUserAndToken(Iterable<CommunicationTokenScope> scopes) {
        return this.createUserAndToken(scopes, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CommunicationUserIdentifierAndToken>> createUserAndTokenWithResponse(Iterable<CommunicationTokenScope> scopes, Duration tokenExpiresIn) {
        try {
            Objects.requireNonNull(scopes);
            CommunicationIdentityCreateRequest communicationIdentityCreateRequest = CommunicationIdentityClientUtils.createCommunicationIdentityCreateRequest(scopes, tokenExpiresIn, this.logger);
            return this.client.createWithResponseAsync(communicationIdentityCreateRequest).onErrorMap(CommunicationErrorResponseException.class, IdentityErrorConverter::translateException).flatMap(response -> Mono.just((Object)new SimpleResponse(response, (Object)this.userWithAccessTokenResultConverter((CommunicationIdentityAccessTokenResult)response.getValue()))));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CommunicationUserIdentifierAndToken>> createUserAndTokenWithResponse(Iterable<CommunicationTokenScope> scopes) {
        return this.createUserAndTokenWithResponse(scopes, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteUser(CommunicationUserIdentifier communicationUser) {
        try {
            Objects.requireNonNull(communicationUser);
            return this.client.deleteAsync(communicationUser.getId()).onErrorMap(CommunicationErrorResponseException.class, IdentityErrorConverter::translateException);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteUserWithResponse(CommunicationUserIdentifier communicationUser) {
        try {
            Objects.requireNonNull(communicationUser);
            return this.client.deleteWithResponseAsync(communicationUser.getId()).onErrorMap(CommunicationErrorResponseException.class, IdentityErrorConverter::translateException);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> revokeTokens(CommunicationUserIdentifier communicationUser) {
        try {
            Objects.requireNonNull(communicationUser);
            return this.client.revokeAccessTokensAsync(communicationUser.getId()).onErrorMap(CommunicationErrorResponseException.class, IdentityErrorConverter::translateException);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> revokeTokensWithResponse(CommunicationUserIdentifier communicationUser) {
        try {
            Objects.requireNonNull(communicationUser);
            return this.client.revokeAccessTokensWithResponseAsync(communicationUser.getId()).onErrorMap(CommunicationErrorResponseException.class, IdentityErrorConverter::translateException);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AccessToken> getToken(CommunicationUserIdentifier communicationUser, Iterable<CommunicationTokenScope> scopes, Duration tokenExpiresIn) {
        try {
            Objects.requireNonNull(communicationUser);
            Objects.requireNonNull(scopes);
            CommunicationIdentityAccessTokenRequest tokenRequest = CommunicationIdentityClientUtils.createCommunicationIdentityAccessTokenRequest(scopes, tokenExpiresIn, this.logger);
            return this.client.issueAccessTokenAsync(communicationUser.getId(), tokenRequest).onErrorMap(CommunicationErrorResponseException.class, IdentityErrorConverter::translateException).flatMap(rawToken -> Mono.just((Object)new AccessToken(rawToken.getToken(), rawToken.getExpiresOn())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AccessToken> getToken(CommunicationUserIdentifier communicationUser, Iterable<CommunicationTokenScope> scopes) {
        return this.getToken(communicationUser, scopes, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AccessToken>> getTokenWithResponse(CommunicationUserIdentifier communicationUser, Iterable<CommunicationTokenScope> scopes, Duration tokenExpiresIn) {
        try {
            Objects.requireNonNull(communicationUser);
            Objects.requireNonNull(scopes);
            CommunicationIdentityAccessTokenRequest tokenRequest = CommunicationIdentityClientUtils.createCommunicationIdentityAccessTokenRequest(scopes, tokenExpiresIn, this.logger);
            return this.client.issueAccessTokenWithResponseAsync(communicationUser.getId(), tokenRequest).onErrorMap(CommunicationErrorResponseException.class, IdentityErrorConverter::translateException).flatMap(response -> {
                AccessToken token = new AccessToken(((CommunicationIdentityAccessToken)response.getValue()).getToken(), ((CommunicationIdentityAccessToken)response.getValue()).getExpiresOn());
                return Mono.just((Object)new SimpleResponse(response, (Object)token));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AccessToken>> getTokenWithResponse(CommunicationUserIdentifier communicationUser, Iterable<CommunicationTokenScope> scopes) {
        return this.getTokenWithResponse(communicationUser, scopes, null);
    }

    private CommunicationUserIdentifierAndToken userWithAccessTokenResultConverter(CommunicationIdentityAccessTokenResult identityAccessTokenResult) {
        CommunicationUserIdentifier user = new CommunicationUserIdentifier(identityAccessTokenResult.getIdentity().getId());
        AccessToken token = new AccessToken(identityAccessTokenResult.getAccessToken().getToken(), identityAccessTokenResult.getAccessToken().getExpiresOn());
        return new CommunicationUserIdentifierAndToken(user, token);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AccessToken> getTokenForTeamsUser(GetTokenForTeamsUserOptions options) {
        try {
            return this.client.exchangeTeamsUserAccessTokenAsync(options).onErrorMap(CommunicationErrorResponseException.class, IdentityErrorConverter::translateException).flatMap(rawToken -> Mono.just((Object)new AccessToken(rawToken.getToken(), rawToken.getExpiresOn())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AccessToken>> getTokenForTeamsUserWithResponse(GetTokenForTeamsUserOptions options) {
        try {
            return this.client.exchangeTeamsUserAccessTokenWithResponseAsync(options).onErrorMap(CommunicationErrorResponseException.class, IdentityErrorConverter::translateException).flatMap(response -> {
                AccessToken token = new AccessToken(((CommunicationIdentityAccessToken)response.getValue()).getToken(), ((CommunicationIdentityAccessToken)response.getValue()).getExpiresOn());
                return Mono.just((Object)new SimpleResponse(response, (Object)token));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }
}

