// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.identity.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** A communication identity with access token. */
@Fluent
public final class CommunicationIdentityAccessTokenResult {
    /*
     * A communication identity.
     */
    @JsonProperty(value = "identity", required = true)
    private CommunicationIdentity identity;

    /*
     * An access token.
     */
    @JsonProperty(value = "accessToken")
    private CommunicationIdentityAccessToken accessToken;

    /** Creates an instance of CommunicationIdentityAccessTokenResult class. */
    public CommunicationIdentityAccessTokenResult() {}

    /**
     * Get the identity property: A communication identity.
     *
     * @return the identity value.
     */
    public CommunicationIdentity getIdentity() {
        return this.identity;
    }

    /**
     * Set the identity property: A communication identity.
     *
     * @param identity the identity value to set.
     * @return the CommunicationIdentityAccessTokenResult object itself.
     */
    public CommunicationIdentityAccessTokenResult setIdentity(CommunicationIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the accessToken property: An access token.
     *
     * @return the accessToken value.
     */
    public CommunicationIdentityAccessToken getAccessToken() {
        return this.accessToken;
    }

    /**
     * Set the accessToken property: An access token.
     *
     * @param accessToken the accessToken value to set.
     * @return the CommunicationIdentityAccessTokenResult object itself.
     */
    public CommunicationIdentityAccessTokenResult setAccessToken(CommunicationIdentityAccessToken accessToken) {
        this.accessToken = accessToken;
        return this;
    }
}
