/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.identity.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class CommunicationIdentityAccessToken
implements JsonSerializable<CommunicationIdentityAccessToken> {
    private String token;
    private OffsetDateTime expiresOn;

    public String getToken() {
        return this.token;
    }

    public CommunicationIdentityAccessToken setToken(String token) {
        this.token = token;
        return this;
    }

    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    public CommunicationIdentityAccessToken setExpiresOn(OffsetDateTime expiresOn) {
        this.expiresOn = expiresOn;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("token", this.token);
        jsonWriter.writeStringField("expiresOn", this.expiresOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiresOn));
        return jsonWriter.writeEndObject();
    }

    public static CommunicationIdentityAccessToken fromJson(JsonReader jsonReader) throws IOException {
        return (CommunicationIdentityAccessToken)jsonReader.readObject(reader -> {
            CommunicationIdentityAccessToken deserializedCommunicationIdentityAccessToken = new CommunicationIdentityAccessToken();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("token".equals(fieldName)) {
                    deserializedCommunicationIdentityAccessToken.token = reader.getString();
                    continue;
                }
                if ("expiresOn".equals(fieldName)) {
                    deserializedCommunicationIdentityAccessToken.expiresOn = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCommunicationIdentityAccessToken;
        });
    }
}

