/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.identity.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class GetTokenForTeamsUserOptions
implements JsonSerializable<GetTokenForTeamsUserOptions> {
    private String teamsUserAadToken;
    private String clientId;
    private String userObjectId;

    public GetTokenForTeamsUserOptions(String teamsUserAadToken, String clientId, String userObjectId) {
        this.teamsUserAadToken = teamsUserAadToken;
        this.clientId = clientId;
        this.userObjectId = userObjectId;
    }

    public String getTeamsUserAadToken() {
        return this.teamsUserAadToken;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getUserObjectId() {
        return this.userObjectId;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("token", this.teamsUserAadToken);
        jsonWriter.writeStringField("appId", this.clientId);
        jsonWriter.writeStringField("userId", this.userObjectId);
        return jsonWriter.writeEndObject();
    }

    public static GetTokenForTeamsUserOptions fromJson(JsonReader jsonReader) throws IOException {
        return (GetTokenForTeamsUserOptions)jsonReader.readObject(reader -> {
            String teamsUserAadToken = null;
            String clientId = null;
            String userObjectId = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("token".equals(fieldName)) {
                    teamsUserAadToken = reader.getString();
                    continue;
                }
                if ("appId".equals(fieldName)) {
                    clientId = reader.getString();
                    continue;
                }
                if ("userId".equals(fieldName)) {
                    userObjectId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new GetTokenForTeamsUserOptions(teamsUserAadToken, clientId, userObjectId);
        });
    }
}

