/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.identity.implementation.models;

import com.azure.communication.identity.models.CommunicationTokenScope;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class CommunicationIdentityAccessTokenRequest
implements JsonSerializable<CommunicationIdentityAccessTokenRequest> {
    private List<CommunicationTokenScope> scopes;
    private Integer expiresInMinutes;

    public List<CommunicationTokenScope> getScopes() {
        return this.scopes;
    }

    public CommunicationIdentityAccessTokenRequest setScopes(List<CommunicationTokenScope> scopes) {
        this.scopes = scopes;
        return this;
    }

    public Integer getExpiresInMinutes() {
        return this.expiresInMinutes;
    }

    public CommunicationIdentityAccessTokenRequest setExpiresInMinutes(Integer expiresInMinutes) {
        this.expiresInMinutes = expiresInMinutes;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("scopes", this.scopes, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeNumberField("expiresInMinutes", (Number)this.expiresInMinutes);
        return jsonWriter.writeEndObject();
    }

    public static CommunicationIdentityAccessTokenRequest fromJson(JsonReader jsonReader) throws IOException {
        return (CommunicationIdentityAccessTokenRequest)jsonReader.readObject(reader -> {
            CommunicationIdentityAccessTokenRequest deserializedCommunicationIdentityAccessTokenRequest = new CommunicationIdentityAccessTokenRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scopes".equals(fieldName)) {
                    List scopes;
                    deserializedCommunicationIdentityAccessTokenRequest.scopes = scopes = reader.readArray(reader1 -> CommunicationTokenScope.fromString(reader1.getString()));
                    continue;
                }
                if ("expiresInMinutes".equals(fieldName)) {
                    deserializedCommunicationIdentityAccessTokenRequest.expiresInMinutes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCommunicationIdentityAccessTokenRequest;
        });
    }
}

