/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.identity.implementation.models;

import com.azure.communication.identity.models.CommunicationTokenScope;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class CommunicationIdentityCreateRequest
implements JsonSerializable<CommunicationIdentityCreateRequest> {
    private List<CommunicationTokenScope> createTokenWithScopes;
    private Integer expiresInMinutes;

    public List<CommunicationTokenScope> getCreateTokenWithScopes() {
        return this.createTokenWithScopes;
    }

    public CommunicationIdentityCreateRequest setCreateTokenWithScopes(List<CommunicationTokenScope> createTokenWithScopes) {
        this.createTokenWithScopes = createTokenWithScopes;
        return this;
    }

    public Integer getExpiresInMinutes() {
        return this.expiresInMinutes;
    }

    public CommunicationIdentityCreateRequest setExpiresInMinutes(Integer expiresInMinutes) {
        this.expiresInMinutes = expiresInMinutes;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("createTokenWithScopes", this.createTokenWithScopes, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeNumberField("expiresInMinutes", (Number)this.expiresInMinutes);
        return jsonWriter.writeEndObject();
    }

    public static CommunicationIdentityCreateRequest fromJson(JsonReader jsonReader) throws IOException {
        return (CommunicationIdentityCreateRequest)jsonReader.readObject(reader -> {
            CommunicationIdentityCreateRequest deserializedCommunicationIdentityCreateRequest = new CommunicationIdentityCreateRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createTokenWithScopes".equals(fieldName)) {
                    List createTokenWithScopes;
                    deserializedCommunicationIdentityCreateRequest.createTokenWithScopes = createTokenWithScopes = reader.readArray(reader1 -> CommunicationTokenScope.fromString(reader1.getString()));
                    continue;
                }
                if ("expiresInMinutes".equals(fieldName)) {
                    deserializedCommunicationIdentityCreateRequest.expiresInMinutes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCommunicationIdentityCreateRequest;
        });
    }
}

