/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.networktraversal;

import com.azure.communication.common.CommunicationUserIdentifier;
import com.azure.communication.networktraversal.CommunicationRelayClientBuilder;
import com.azure.communication.networktraversal.implementation.CommunicationNetworkTraversalsImpl;
import com.azure.communication.networktraversal.implementation.CommunicationNetworkingClientImpl;
import com.azure.communication.networktraversal.models.CommunicationErrorResponseException;
import com.azure.communication.networktraversal.models.CommunicationRelayConfiguration;
import com.azure.communication.networktraversal.models.CommunicationRelayConfigurationRequest;
import com.azure.communication.networktraversal.models.RouteType;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import reactor.core.publisher.Mono;

@ServiceClient(builder=CommunicationRelayClientBuilder.class, isAsync=true)
public final class CommunicationRelayAsyncClient {
    private final CommunicationNetworkTraversalsImpl client;
    private final ClientLogger logger = new ClientLogger(CommunicationRelayAsyncClient.class);

    CommunicationRelayAsyncClient(CommunicationNetworkingClientImpl communicationNetworkingClient) {
        this.client = communicationNetworkingClient.getCommunicationNetworkTraversals();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CommunicationRelayConfiguration> getRelayConfiguration() {
        return this.getRelayConfigurationWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CommunicationRelayConfiguration> getRelayConfiguration(CommunicationUserIdentifier communicationUser) {
        return this.getRelayConfigurationWithResponse(communicationUser, null, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CommunicationRelayConfiguration> getRelayConfiguration(RouteType routeType) {
        return this.getRelayConfigurationWithResponse(null, routeType, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CommunicationRelayConfiguration> getRelayConfiguration(CommunicationUserIdentifier communicationUser, RouteType routeType) {
        return this.getRelayConfigurationWithResponse(communicationUser, routeType, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CommunicationRelayConfiguration>> getRelayConfigurationWithResponse() {
        return FluxUtil.withContext(context -> this.getRelayConfigurationWithResponse(null, null, (Context)context));
    }

    Mono<Response<CommunicationRelayConfiguration>> getRelayConfigurationWithResponse(CommunicationUserIdentifier communicationUser, RouteType routeType, Context context) {
        context = context == null ? Context.NONE : context;
        try {
            CommunicationRelayConfigurationRequest body = new CommunicationRelayConfigurationRequest();
            if (communicationUser != null) {
                body.setId(communicationUser.getId());
            }
            if (routeType != null) {
                body.setRouteType(routeType);
            }
            return this.client.issueRelayConfigurationWithResponseAsync(body, context).onErrorMap(CommunicationErrorResponseException.class, e -> e);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }
}

