/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.networktraversal;

import com.azure.communication.common.CommunicationUserIdentifier;
import com.azure.communication.networktraversal.CommunicationRelayAsyncClient;
import com.azure.communication.networktraversal.CommunicationRelayClientBuilder;
import com.azure.communication.networktraversal.models.CommunicationRelayConfiguration;
import com.azure.communication.networktraversal.models.RouteType;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;

@ServiceClient(builder=CommunicationRelayClientBuilder.class, isAsync=false)
public final class CommunicationRelayClient {
    private final CommunicationRelayAsyncClient client;
    private final ClientLogger logger = new ClientLogger(CommunicationRelayClient.class);

    CommunicationRelayClient(CommunicationRelayAsyncClient communicationNetworkingClient) {
        this.client = communicationNetworkingClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CommunicationRelayConfiguration getRelayConfiguration() {
        return (CommunicationRelayConfiguration)this.client.getRelayConfiguration().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CommunicationRelayConfiguration getRelayConfiguration(CommunicationUserIdentifier communicationUser) {
        return (CommunicationRelayConfiguration)this.client.getRelayConfiguration(communicationUser).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CommunicationRelayConfiguration getRelayConfiguration(RouteType routeType) {
        return (CommunicationRelayConfiguration)this.client.getRelayConfiguration(routeType).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CommunicationRelayConfiguration getRelayConfiguration(CommunicationUserIdentifier communicationUser, RouteType routeType) {
        return (CommunicationRelayConfiguration)this.client.getRelayConfiguration(communicationUser, routeType).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CommunicationRelayConfiguration> getRelayConfigurationWithResponse(CommunicationUserIdentifier communicationUser, RouteType routeType, Context context) {
        Response response = (Response)this.client.getRelayConfigurationWithResponse(communicationUser, routeType, context).block();
        return response;
    }
}

