/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.networktraversal;

import com.azure.communication.common.implementation.CommunicationConnectionString;
import com.azure.communication.common.implementation.HmacAuthenticationPolicy;
import com.azure.communication.networktraversal.CommunicationRelayAsyncClient;
import com.azure.communication.networktraversal.CommunicationRelayClient;
import com.azure.communication.networktraversal.CommunicationRelayServiceVersion;
import com.azure.communication.networktraversal.implementation.CommunicationNetworkingClientImpl;
import com.azure.communication.networktraversal.implementation.CommunicationNetworkingClientImplBuilder;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={CommunicationRelayClient.class, CommunicationRelayAsyncClient.class})
public final class CommunicationRelayClientBuilder {
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private static final String COMMUNICATION_NETWORK_TRAVERSAL_PROPERTIES = "azure-communication-networktraversal.properties";
    private final ClientLogger logger = new ClientLogger(CommunicationRelayClientBuilder.class);
    private String endpoint;
    private AzureKeyCredential azureKeyCredential;
    private TokenCredential tokenCredential;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions = new HttpLogOptions();
    private HttpPipeline pipeline;
    private RetryPolicy retryPolicy;
    private Configuration configuration;
    private ClientOptions clientOptions;
    private String connectionString;
    private final Map<String, String> properties = CoreUtils.getProperties((String)"azure-communication-networktraversal.properties");
    private final List<HttpPipelinePolicy> customPolicies = new ArrayList<HttpPipelinePolicy>();

    public CommunicationRelayClientBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public CommunicationRelayClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public CommunicationRelayClientBuilder credential(TokenCredential tokenCredential) {
        this.tokenCredential = tokenCredential;
        return this;
    }

    public CommunicationRelayClientBuilder credential(AzureKeyCredential keyCredential) {
        this.azureKeyCredential = keyCredential;
        return this;
    }

    public CommunicationRelayClientBuilder connectionString(String connectionString) {
        CommunicationConnectionString connectionStringObject = new CommunicationConnectionString(connectionString);
        String endpoint = connectionStringObject.getEndpoint();
        String accessKey = connectionStringObject.getAccessKey();
        this.endpoint(endpoint).credential(new AzureKeyCredential(accessKey));
        return this;
    }

    public CommunicationRelayClientBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public CommunicationRelayClientBuilder addPolicy(HttpPipelinePolicy customPolicy) {
        this.customPolicies.add(customPolicy);
        return this;
    }

    public CommunicationRelayClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public CommunicationRelayClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public CommunicationRelayClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public CommunicationRelayClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public CommunicationRelayClientBuilder serviceVersion(CommunicationRelayServiceVersion version) {
        return this;
    }

    public CommunicationRelayAsyncClient buildAsyncClient() {
        Objects.requireNonNull(this.endpoint, "'endpoint' cannot be null.");
        return new CommunicationRelayAsyncClient(this.createServiceImpl());
    }

    public CommunicationRelayClient buildClient() {
        return new CommunicationRelayClient(this.buildAsyncClient());
    }

    private CommunicationNetworkingClientImpl createServiceImpl() {
        HttpPipeline builderPipeline = this.pipeline;
        if (this.pipeline == null) {
            builderPipeline = this.createHttpPipeline(this.httpClient, this.createHttpPipelineAuthPolicy(), this.customPolicies);
        }
        CommunicationNetworkingClientImplBuilder clientBuilder = new CommunicationNetworkingClientImplBuilder();
        clientBuilder.endpoint(this.endpoint).pipeline(builderPipeline);
        return clientBuilder.buildClient();
    }

    private HttpPipelinePolicy createHttpPipelineAuthPolicy() {
        if (this.tokenCredential != null && this.azureKeyCredential != null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Both 'credential' and 'accessKey' are set. Just one may be used."));
        }
        if (this.tokenCredential != null) {
            return new BearerTokenAuthenticationPolicy(this.tokenCredential, new String[]{"https://communication.azure.com//.default"});
        }
        if (this.azureKeyCredential != null) {
            return new HmacAuthenticationPolicy(this.azureKeyCredential);
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing credential information while building a client."));
    }

    private HttpPipeline createHttpPipeline(HttpClient httpClient, HttpPipelinePolicy authorizationPolicy, List<HttpPipelinePolicy> customPolicies) {
        ArrayList<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        this.applyRequiredPolicies(policies, authorizationPolicy);
        if (customPolicies != null && customPolicies.size() > 0) {
            policies.addAll(customPolicies);
        }
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(httpClient).clientOptions(this.clientOptions).build();
    }

    private void applyRequiredPolicies(List<HttpPipelinePolicy> policies, HttpPipelinePolicy authorizationPolicy) {
        String clientName = this.properties.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = this.properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        ClientOptions buildClientOptions = this.clientOptions == null ? new ClientOptions() : this.clientOptions;
        HttpLogOptions buildLogOptions = this.httpLogOptions == null ? new HttpLogOptions() : this.httpLogOptions;
        String applicationId = null;
        if (!CoreUtils.isNullOrEmpty((CharSequence)buildClientOptions.getApplicationId())) {
            applicationId = buildClientOptions.getApplicationId();
        } else if (!CoreUtils.isNullOrEmpty((CharSequence)buildLogOptions.getApplicationId())) {
            applicationId = buildLogOptions.getApplicationId();
        }
        policies.add((HttpPipelinePolicy)new UserAgentPolicy(applicationId, clientName, clientVersion, this.configuration));
        policies.add((HttpPipelinePolicy)new RequestIdPolicy());
        policies.add((HttpPipelinePolicy)(this.retryPolicy == null ? new RetryPolicy() : this.retryPolicy));
        policies.add((HttpPipelinePolicy)new CookiePolicy());
        policies.add(authorizationPolicy);
        policies.add((HttpPipelinePolicy)new HttpLoggingPolicy(this.httpLogOptions));
    }
}

