/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.networktraversal.implementation;

import com.azure.communication.networktraversal.implementation.CommunicationNetworkingClientImpl;
import com.azure.communication.networktraversal.models.CommunicationErrorResponseException;
import com.azure.communication.networktraversal.models.CommunicationRelayConfiguration;
import com.azure.communication.networktraversal.models.CommunicationRelayConfigurationRequest;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class CommunicationNetworkTraversalsImpl {
    private final CommunicationNetworkTraversalsService service;
    private final CommunicationNetworkingClientImpl client;

    CommunicationNetworkTraversalsImpl(CommunicationNetworkingClientImpl client) {
        this.service = (CommunicationNetworkTraversalsService)RestProxy.create(CommunicationNetworkTraversalsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CommunicationRelayConfiguration>> issueRelayConfigurationWithResponseAsync(CommunicationRelayConfigurationRequest body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.issueRelayConfiguration(this.client.getEndpoint(), this.client.getApiVersion(), body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CommunicationRelayConfiguration>> issueRelayConfigurationWithResponseAsync(CommunicationRelayConfigurationRequest body, Context context) {
        String accept = "application/json";
        return this.service.issueRelayConfiguration(this.client.getEndpoint(), this.client.getApiVersion(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CommunicationRelayConfiguration> issueRelayConfigurationAsync(CommunicationRelayConfigurationRequest body) {
        return this.issueRelayConfigurationWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CommunicationRelayConfiguration)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CommunicationRelayConfiguration> issueRelayConfigurationAsync(CommunicationRelayConfigurationRequest body, Context context) {
        return this.issueRelayConfigurationWithResponseAsync(body, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CommunicationRelayConfiguration)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CommunicationRelayConfiguration issueRelayConfiguration(CommunicationRelayConfigurationRequest body) {
        return (CommunicationRelayConfiguration)this.issueRelayConfigurationAsync(body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CommunicationRelayConfiguration> issueRelayConfigurationWithResponse(CommunicationRelayConfigurationRequest body, Context context) {
        return (Response)this.issueRelayConfigurationWithResponseAsync(body, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="CommunicationNetwork")
    private static interface CommunicationNetworkTraversalsService {
        @Post(value="/networktraversal/:issueRelayConfiguration")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<CommunicationRelayConfiguration>> issueRelayConfiguration(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") CommunicationRelayConfigurationRequest var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

