/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.phonenumbers;

import com.azure.communication.phonenumbers.PhoneNumbersAsyncClient;
import com.azure.communication.phonenumbers.PhoneNumbersClientBuilder;
import com.azure.communication.phonenumbers.implementation.PhoneNumberAdminClientImpl;
import com.azure.communication.phonenumbers.implementation.PhoneNumbersImpl;
import com.azure.communication.phonenumbers.models.PhoneNumberAssignmentType;
import com.azure.communication.phonenumbers.models.PhoneNumberCapabilities;
import com.azure.communication.phonenumbers.models.PhoneNumberOperation;
import com.azure.communication.phonenumbers.models.PhoneNumberSearchOptions;
import com.azure.communication.phonenumbers.models.PhoneNumberSearchResult;
import com.azure.communication.phonenumbers.models.PhoneNumberType;
import com.azure.communication.phonenumbers.models.PurchasePhoneNumbersResult;
import com.azure.communication.phonenumbers.models.PurchasedPhoneNumber;
import com.azure.communication.phonenumbers.models.ReleasePhoneNumberResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.SyncPoller;
import java.util.Objects;

@ServiceClient(builder=PhoneNumbersClientBuilder.class, isAsync=false)
public final class PhoneNumbersClient {
    private final ClientLogger logger = new ClientLogger(PhoneNumbersClient.class);
    private final PhoneNumbersImpl client;
    private final PhoneNumbersAsyncClient asyncClient;

    PhoneNumbersClient(PhoneNumberAdminClientImpl phoneNumberAdminClient, PhoneNumbersAsyncClient asyncClient) {
        this.client = phoneNumberAdminClient.getPhoneNumbers();
        this.asyncClient = asyncClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PurchasedPhoneNumber getPurchasedPhoneNumber(String phoneNumber) {
        Objects.requireNonNull(phoneNumber, "'phoneNumber' cannot be null.");
        return this.client.getByNumber(phoneNumber);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PurchasedPhoneNumber> getPurchasedPhoneNumberWithResponse(String phoneNumber, Context context) {
        Objects.requireNonNull(phoneNumber, "'phoneNumber' cannot be null.");
        context = context == null ? Context.NONE : context;
        return (Response)this.client.getByNumberWithResponseAsync(phoneNumber, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PurchasedPhoneNumber> listPurchasedPhoneNumbers() {
        return this.listPurchasedPhoneNumbers(null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PurchasedPhoneNumber> listPurchasedPhoneNumbers(Context context) {
        context = context == null ? Context.NONE : context;
        return this.client.listPhoneNumbers(null, null, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PhoneNumberOperation, PhoneNumberSearchResult> beginSearchAvailablePhoneNumbers(String countryCode, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, PhoneNumberCapabilities capabilities) {
        return this.asyncClient.beginSearchAvailablePhoneNumbers(countryCode, phoneNumberType, assignmentType, capabilities).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PhoneNumberOperation, PhoneNumberSearchResult> beginSearchAvailablePhoneNumbers(String countryCode, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, PhoneNumberCapabilities capabilities, PhoneNumberSearchOptions searchOptions, Context context) {
        return this.asyncClient.beginSearchAvailablePhoneNumbers(countryCode, phoneNumberType, assignmentType, capabilities, searchOptions, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PhoneNumberOperation, PurchasePhoneNumbersResult> beginPurchasePhoneNumbers(String searchId) {
        return this.asyncClient.beginPurchasePhoneNumbers(searchId).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PhoneNumberOperation, PurchasePhoneNumbersResult> beginPurchasePhoneNumbers(String searchId, Context context) {
        return this.asyncClient.beginPurchasePhoneNumbers(searchId, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PhoneNumberOperation, ReleasePhoneNumberResult> beginReleasePhoneNumber(String phoneNumber) {
        return this.asyncClient.beginReleasePhoneNumber(phoneNumber).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PhoneNumberOperation, ReleasePhoneNumberResult> beginReleasePhoneNumber(String phoneNumber, Context context) {
        return this.asyncClient.beginReleasePhoneNumber(phoneNumber, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PhoneNumberOperation, PurchasedPhoneNumber> beginUpdatePhoneNumberCapabilities(String phoneNumber, PhoneNumberCapabilities capabilities) {
        return this.asyncClient.beginUpdatePhoneNumberCapabilities(phoneNumber, capabilities).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PhoneNumberOperation, PurchasedPhoneNumber> beginUpdatePhoneNumberCapabilities(String phoneNumber, PhoneNumberCapabilities capabilities, Context context) {
        return this.asyncClient.beginUpdatePhoneNumberCapabilities(phoneNumber, capabilities, context).getSyncPoller();
    }
}

