/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.phonenumbers.implementation;

import com.azure.communication.phonenumbers.implementation.PhoneNumberAdminClientImpl;
import com.azure.communication.phonenumbers.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberCapabilitiesRequest;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberPurchaseRequest;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberRawOperation;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberSearchRequest;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersGetOperationResponse;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersPurchasePhoneNumbersResponse;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersReleasePhoneNumberResponse;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersSearchAvailablePhoneNumbersResponse;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersUpdateCapabilitiesResponse;
import com.azure.communication.phonenumbers.implementation.models.PurchasedPhoneNumbers;
import com.azure.communication.phonenumbers.models.PhoneNumberSearchResult;
import com.azure.communication.phonenumbers.models.PurchasedPhoneNumber;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class PhoneNumbersImpl {
    private final PhoneNumbersService service;
    private final PhoneNumberAdminClientImpl client;

    PhoneNumbersImpl(PhoneNumberAdminClientImpl client) {
        this.service = (PhoneNumbersService)RestProxy.create(PhoneNumbersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersSearchAvailablePhoneNumbersResponse> searchAvailablePhoneNumbersWithResponseAsync(String countryCode, PhoneNumberSearchRequest body) {
        return FluxUtil.withContext(context -> this.service.searchAvailablePhoneNumbers(this.client.getEndpoint(), countryCode, this.client.getApiVersion(), body, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersSearchAvailablePhoneNumbersResponse> searchAvailablePhoneNumbersWithResponseAsync(String countryCode, PhoneNumberSearchRequest body, Context context) {
        return this.service.searchAvailablePhoneNumbers(this.client.getEndpoint(), countryCode, this.client.getApiVersion(), body, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumberSearchResult> searchAvailablePhoneNumbersAsync(String countryCode, PhoneNumberSearchRequest body) {
        return this.searchAvailablePhoneNumbersWithResponseAsync(countryCode, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumberSearchResult> searchAvailablePhoneNumbersAsync(String countryCode, PhoneNumberSearchRequest body, Context context) {
        return this.searchAvailablePhoneNumbersWithResponseAsync(countryCode, body, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PhoneNumberSearchResult searchAvailablePhoneNumbers(String countryCode, PhoneNumberSearchRequest body) {
        return (PhoneNumberSearchResult)this.searchAvailablePhoneNumbersAsync(countryCode, body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PhoneNumberSearchResult searchAvailablePhoneNumbers(String countryCode, PhoneNumberSearchRequest body, Context context) {
        return (PhoneNumberSearchResult)this.searchAvailablePhoneNumbersAsync(countryCode, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PhoneNumberSearchResult>> getSearchResultWithResponseAsync(String searchId) {
        return FluxUtil.withContext(context -> this.service.getSearchResult(this.client.getEndpoint(), searchId, this.client.getApiVersion(), (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PhoneNumberSearchResult>> getSearchResultWithResponseAsync(String searchId, Context context) {
        return this.service.getSearchResult(this.client.getEndpoint(), searchId, this.client.getApiVersion(), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumberSearchResult> getSearchResultAsync(String searchId) {
        return this.getSearchResultWithResponseAsync(searchId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((PhoneNumberSearchResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumberSearchResult> getSearchResultAsync(String searchId, Context context) {
        return this.getSearchResultWithResponseAsync(searchId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((PhoneNumberSearchResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PhoneNumberSearchResult getSearchResult(String searchId) {
        return (PhoneNumberSearchResult)this.getSearchResultAsync(searchId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PhoneNumberSearchResult getSearchResult(String searchId, Context context) {
        return (PhoneNumberSearchResult)this.getSearchResultAsync(searchId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersPurchasePhoneNumbersResponse> purchasePhoneNumbersWithResponseAsync(PhoneNumberPurchaseRequest body) {
        return FluxUtil.withContext(context -> this.service.purchasePhoneNumbers(this.client.getEndpoint(), this.client.getApiVersion(), body, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersPurchasePhoneNumbersResponse> purchasePhoneNumbersWithResponseAsync(PhoneNumberPurchaseRequest body, Context context) {
        return this.service.purchasePhoneNumbers(this.client.getEndpoint(), this.client.getApiVersion(), body, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purchasePhoneNumbersAsync(PhoneNumberPurchaseRequest body) {
        return this.purchasePhoneNumbersWithResponseAsync(body).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purchasePhoneNumbersAsync(PhoneNumberPurchaseRequest body, Context context) {
        return this.purchasePhoneNumbersWithResponseAsync(body, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purchasePhoneNumbers(PhoneNumberPurchaseRequest body) {
        this.purchasePhoneNumbersAsync(body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purchasePhoneNumbers(PhoneNumberPurchaseRequest body, Context context) {
        this.purchasePhoneNumbersAsync(body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersGetOperationResponse> getOperationWithResponseAsync(String operationId) {
        return FluxUtil.withContext(context -> this.service.getOperation(this.client.getEndpoint(), operationId, this.client.getApiVersion(), (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersGetOperationResponse> getOperationWithResponseAsync(String operationId, Context context) {
        return this.service.getOperation(this.client.getEndpoint(), operationId, this.client.getApiVersion(), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumberRawOperation> getOperationAsync(String operationId) {
        return this.getOperationWithResponseAsync(operationId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumberRawOperation> getOperationAsync(String operationId, Context context) {
        return this.getOperationWithResponseAsync(operationId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PhoneNumberRawOperation getOperation(String operationId) {
        return (PhoneNumberRawOperation)this.getOperationAsync(operationId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PhoneNumberRawOperation getOperation(String operationId, Context context) {
        return (PhoneNumberRawOperation)this.getOperationAsync(operationId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelOperationWithResponseAsync(String operationId) {
        return FluxUtil.withContext(context -> this.service.cancelOperation(this.client.getEndpoint(), operationId, this.client.getApiVersion(), (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelOperationWithResponseAsync(String operationId, Context context) {
        return this.service.cancelOperation(this.client.getEndpoint(), operationId, this.client.getApiVersion(), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelOperationAsync(String operationId) {
        return this.cancelOperationWithResponseAsync(operationId).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelOperationAsync(String operationId, Context context) {
        return this.cancelOperationWithResponseAsync(operationId, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelOperation(String operationId) {
        this.cancelOperationAsync(operationId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelOperation(String operationId, Context context) {
        this.cancelOperationAsync(operationId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersUpdateCapabilitiesResponse> updateCapabilitiesWithResponseAsync(String phoneNumber, PhoneNumberCapabilitiesRequest body) {
        return FluxUtil.withContext(context -> this.service.updateCapabilities(this.client.getEndpoint(), phoneNumber, this.client.getApiVersion(), body, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersUpdateCapabilitiesResponse> updateCapabilitiesWithResponseAsync(String phoneNumber, PhoneNumberCapabilitiesRequest body, Context context) {
        return this.service.updateCapabilities(this.client.getEndpoint(), phoneNumber, this.client.getApiVersion(), body, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PurchasedPhoneNumber> updateCapabilitiesAsync(String phoneNumber, PhoneNumberCapabilitiesRequest body) {
        return this.updateCapabilitiesWithResponseAsync(phoneNumber, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PurchasedPhoneNumber> updateCapabilitiesAsync(String phoneNumber, PhoneNumberCapabilitiesRequest body, Context context) {
        return this.updateCapabilitiesWithResponseAsync(phoneNumber, body, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PurchasedPhoneNumber updateCapabilities(String phoneNumber, PhoneNumberCapabilitiesRequest body) {
        return (PurchasedPhoneNumber)this.updateCapabilitiesAsync(phoneNumber, body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PurchasedPhoneNumber updateCapabilities(String phoneNumber, PhoneNumberCapabilitiesRequest body, Context context) {
        return (PurchasedPhoneNumber)this.updateCapabilitiesAsync(phoneNumber, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PurchasedPhoneNumber>> getByNumberWithResponseAsync(String phoneNumber) {
        return FluxUtil.withContext(context -> this.service.getByNumber(this.client.getEndpoint(), phoneNumber, this.client.getApiVersion(), (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PurchasedPhoneNumber>> getByNumberWithResponseAsync(String phoneNumber, Context context) {
        return this.service.getByNumber(this.client.getEndpoint(), phoneNumber, this.client.getApiVersion(), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PurchasedPhoneNumber> getByNumberAsync(String phoneNumber) {
        return this.getByNumberWithResponseAsync(phoneNumber).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((PurchasedPhoneNumber)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PurchasedPhoneNumber> getByNumberAsync(String phoneNumber, Context context) {
        return this.getByNumberWithResponseAsync(phoneNumber, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((PurchasedPhoneNumber)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PurchasedPhoneNumber getByNumber(String phoneNumber) {
        return (PurchasedPhoneNumber)this.getByNumberAsync(phoneNumber).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PurchasedPhoneNumber getByNumber(String phoneNumber, Context context) {
        return (PurchasedPhoneNumber)this.getByNumberAsync(phoneNumber, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersReleasePhoneNumberResponse> releasePhoneNumberWithResponseAsync(String phoneNumber) {
        return FluxUtil.withContext(context -> this.service.releasePhoneNumber(this.client.getEndpoint(), phoneNumber, this.client.getApiVersion(), (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersReleasePhoneNumberResponse> releasePhoneNumberWithResponseAsync(String phoneNumber, Context context) {
        return this.service.releasePhoneNumber(this.client.getEndpoint(), phoneNumber, this.client.getApiVersion(), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> releasePhoneNumberAsync(String phoneNumber) {
        return this.releasePhoneNumberWithResponseAsync(phoneNumber).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> releasePhoneNumberAsync(String phoneNumber, Context context) {
        return this.releasePhoneNumberWithResponseAsync(phoneNumber, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void releasePhoneNumber(String phoneNumber) {
        this.releasePhoneNumberAsync(phoneNumber).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void releasePhoneNumber(String phoneNumber, Context context) {
        this.releasePhoneNumberAsync(phoneNumber, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PurchasedPhoneNumber>> listPhoneNumbersSinglePageAsync(Integer skip, Integer top) {
        return FluxUtil.withContext(context -> this.service.listPhoneNumbers(this.client.getEndpoint(), skip, top, this.client.getApiVersion(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PurchasedPhoneNumbers)res.getValue()).getPhoneNumbers(), ((PurchasedPhoneNumbers)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PurchasedPhoneNumber>> listPhoneNumbersSinglePageAsync(Integer skip, Integer top, Context context) {
        return this.service.listPhoneNumbers(this.client.getEndpoint(), skip, top, this.client.getApiVersion(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PurchasedPhoneNumbers)res.getValue()).getPhoneNumbers(), ((PurchasedPhoneNumbers)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PurchasedPhoneNumber> listPhoneNumbersAsync(Integer skip, Integer top) {
        return new PagedFlux(() -> this.listPhoneNumbersSinglePageAsync(skip, top), nextLink -> this.listPhoneNumbersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PurchasedPhoneNumber> listPhoneNumbersAsync(Integer skip, Integer top, Context context) {
        return new PagedFlux(() -> this.listPhoneNumbersSinglePageAsync(skip, top, context), nextLink -> this.listPhoneNumbersNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PurchasedPhoneNumber> listPhoneNumbers(Integer skip, Integer top) {
        return new PagedIterable(this.listPhoneNumbersAsync(skip, top));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PurchasedPhoneNumber> listPhoneNumbers(Integer skip, Integer top, Context context) {
        return new PagedIterable(this.listPhoneNumbersAsync(skip, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PurchasedPhoneNumber>> listPhoneNumbersNextSinglePageAsync(String nextLink) {
        return FluxUtil.withContext(context -> this.service.listPhoneNumbersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PurchasedPhoneNumbers)res.getValue()).getPhoneNumbers(), ((PurchasedPhoneNumbers)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PurchasedPhoneNumber>> listPhoneNumbersNextSinglePageAsync(String nextLink, Context context) {
        return this.service.listPhoneNumbersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PurchasedPhoneNumbers)res.getValue()).getPhoneNumbers(), ((PurchasedPhoneNumbers)res.getValue()).getNextLink(), null));
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="PhoneNumberAdminClie")
    private static interface PhoneNumbersService {
        @Post(value="/availablePhoneNumbers/countries/{countryCode}/:search")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<PhoneNumbersSearchAvailablePhoneNumbersResponse> searchAvailablePhoneNumbers(@HostParam(value="endpoint") String var1, @PathParam(value="countryCode") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") PhoneNumberSearchRequest var4, Context var5);

        @Get(value="/availablePhoneNumbers/searchResults/{searchId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PhoneNumberSearchResult>> getSearchResult(@HostParam(value="endpoint") String var1, @PathParam(value="searchId") String var2, @QueryParam(value="api-version") String var3, Context var4);

        @Post(value="/availablePhoneNumbers/:purchase")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<PhoneNumbersPurchasePhoneNumbersResponse> purchasePhoneNumbers(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") PhoneNumberPurchaseRequest var3, Context var4);

        @Get(value="/phoneNumbers/operations/{operationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<PhoneNumbersGetOperationResponse> getOperation(@HostParam(value="endpoint") String var1, @PathParam(value="operationId") String var2, @QueryParam(value="api-version") String var3, Context var4);

        @Delete(value="/phoneNumbers/operations/{operationId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> cancelOperation(@HostParam(value="endpoint") String var1, @PathParam(value="operationId") String var2, @QueryParam(value="api-version") String var3, Context var4);

        @Patch(value="/phoneNumbers/{phoneNumber}/capabilities")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<PhoneNumbersUpdateCapabilitiesResponse> updateCapabilities(@HostParam(value="endpoint") String var1, @PathParam(value="phoneNumber") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/merge-patch+json") PhoneNumberCapabilitiesRequest var4, Context var5);

        @Get(value="/phoneNumbers/{phoneNumber}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PurchasedPhoneNumber>> getByNumber(@HostParam(value="endpoint") String var1, @PathParam(value="phoneNumber") String var2, @QueryParam(value="api-version") String var3, Context var4);

        @Delete(value="/phoneNumbers/{phoneNumber}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<PhoneNumbersReleasePhoneNumberResponse> releasePhoneNumber(@HostParam(value="endpoint") String var1, @PathParam(value="phoneNumber") String var2, @QueryParam(value="api-version") String var3, Context var4);

        @Get(value="/phoneNumbers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PurchasedPhoneNumbers>> listPhoneNumbers(@HostParam(value="endpoint") String var1, @QueryParam(value="skip") Integer var2, @QueryParam(value="top") Integer var3, @QueryParam(value="api-version") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PurchasedPhoneNumbers>> listPhoneNumbersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

