// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for PhoneNumberAssignmentType. */
public final class PhoneNumberAssignmentType extends ExpandableStringEnum<PhoneNumberAssignmentType> {
    /** Static value person for PhoneNumberAssignmentType. */
    public static final PhoneNumberAssignmentType PERSON = fromString("person");

    /** Static value application for PhoneNumberAssignmentType. */
    public static final PhoneNumberAssignmentType APPLICATION = fromString("application");

    /**
     * Creates or finds a PhoneNumberAssignmentType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding PhoneNumberAssignmentType.
     */
    @JsonCreator
    public static PhoneNumberAssignmentType fromString(String name) {
        return fromString(name, PhoneNumberAssignmentType.class);
    }

    /** @return known PhoneNumberAssignmentType values. */
    public static Collection<PhoneNumberAssignmentType> values() {
        return values(PhoneNumberAssignmentType.class);
    }
}
