// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.siprouting.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/** Represents a SIP configuration update. */
@Fluent
public final class SipConfigurationUpdate {
    /*
     * SIP trunks for routing calls.
     * Map key is trunk's FQDN (1-249 characters).
     */
    @JsonProperty(value = "trunks")
    private Map<String, TrunkUpdate> trunks;

    /*
     * Trunk routes for routing calls.
     */
    @JsonProperty(value = "routes")
    private List<SipTrunkRoute> routes;

    /**
     * Get the trunks property: SIP trunks for routing calls. Map key is trunk's FQDN (1-249 characters).
     *
     * @return the trunks value.
     */
    public Map<String, TrunkUpdate> getTrunks() {
        return this.trunks;
    }

    /**
     * Set the trunks property: SIP trunks for routing calls. Map key is trunk's FQDN (1-249 characters).
     *
     * @param trunks the trunks value to set.
     * @return the SipConfigurationUpdate object itself.
     */
    public SipConfigurationUpdate setTrunks(Map<String, TrunkUpdate> trunks) {
        this.trunks = trunks;
        return this;
    }

    /**
     * Get the routes property: Trunk routes for routing calls.
     *
     * @return the routes value.
     */
    public List<SipTrunkRoute> getRoutes() {
        return this.routes;
    }

    /**
     * Set the routes property: Trunk routes for routing calls.
     *
     * @param routes the routes value to set.
     * @return the SipConfigurationUpdate object itself.
     */
    public SipConfigurationUpdate setRoutes(List<SipTrunkRoute> routes) {
        this.routes = routes;
        return this;
    }
}
