// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.implementation.models;

import com.azure.communication.phonenumbers.models.PhoneNumberAreaCode;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The PhoneNumberAreaCodes model. */
@Immutable
public final class PhoneNumberAreaCodes {
    /*
     * Represents a list of available toll-free area codes.
     */
    @JsonProperty(value = "areaCodes", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private List<PhoneNumberAreaCode> areaCodes;

    /*
     * Represents the URL link to the next page.
     */
    @JsonProperty(value = "nextLink", access = JsonProperty.Access.WRITE_ONLY)
    private String nextLink;

    /**
     * Get the areaCodes property: Represents a list of available toll-free area codes.
     *
     * @return the areaCodes value.
     */
    public List<PhoneNumberAreaCode> getAreaCodes() {
        return this.areaCodes;
    }

    /**
     * Get the nextLink property: Represents the URL link to the next page.
     *
     * @return the nextLink value.
     */
    public String getNextLink() {
        return this.nextLink;
    }
}
