// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The PhoneNumberOffering model. */
@Immutable
public final class PhoneNumberOffering {
    /*
     * Represents the number type of the offering.
     */
    @JsonProperty(value = "phoneNumberType", access = JsonProperty.Access.WRITE_ONLY)
    private PhoneNumberType phoneNumberType;

    /*
     * Represents the assignment type of the offering.
     */
    @JsonProperty(value = "assignmentType", access = JsonProperty.Access.WRITE_ONLY)
    private PhoneNumberAssignmentType assignmentType;

    /*
     * Capabilities of a phone number.
     */
    @JsonProperty(value = "availableCapabilities", access = JsonProperty.Access.WRITE_ONLY)
    private PhoneNumberCapabilities availableCapabilities;

    /*
     * The incurred cost for a single phone number.
     */
    @JsonProperty(value = "cost", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private PhoneNumberCost cost;

    /**
     * Get the phoneNumberType property: Represents the number type of the offering.
     *
     * @return the phoneNumberType value.
     */
    public PhoneNumberType getPhoneNumberType() {
        return this.phoneNumberType;
    }

    /**
     * Get the assignmentType property: Represents the assignment type of the offering.
     *
     * @return the assignmentType value.
     */
    public PhoneNumberAssignmentType getAssignmentType() {
        return this.assignmentType;
    }

    /**
     * Get the availableCapabilities property: Capabilities of a phone number.
     *
     * @return the availableCapabilities value.
     */
    public PhoneNumberCapabilities getAvailableCapabilities() {
        return this.availableCapabilities;
    }

    /**
     * Get the cost property: The incurred cost for a single phone number.
     *
     * @return the cost value.
     */
    public PhoneNumberCost getCost() {
        return this.cost;
    }
}
