/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.phonenumbers.implementation;

import com.azure.communication.phonenumbers.implementation.PhoneNumberAdminClientImpl;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;

@ServiceClientBuilder(serviceClients={PhoneNumberAdminClientImpl.class})
public final class PhoneNumberAdminClientImplBuilder {
    private String endpoint;
    private HttpPipeline pipeline;
    private SerializerAdapter serializerAdapter;

    public PhoneNumberAdminClientImplBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public PhoneNumberAdminClientImplBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public PhoneNumberAdminClientImplBuilder serializerAdapter(SerializerAdapter serializerAdapter) {
        this.serializerAdapter = serializerAdapter;
        return this;
    }

    public PhoneNumberAdminClientImpl buildClient() {
        if (this.pipeline == null) {
            this.pipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build();
        }
        if (this.serializerAdapter == null) {
            this.serializerAdapter = JacksonAdapter.createDefaultSerializerAdapter();
        }
        PhoneNumberAdminClientImpl client = new PhoneNumberAdminClientImpl(this.pipeline, this.serializerAdapter, this.endpoint);
        return client;
    }
}

