// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The PhoneNumberAdministrativeDivision model. */
@Immutable
public final class PhoneNumberAdministrativeDivision {
    /*
     * Represents the localized name of the administrative division of the
     * locality. e.g. state or province localized name.
     */
    @JsonProperty(value = "localizedName", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private String localizedName;

    /*
     * Represents the abbreviated name of the administrative division of the
     * locality. e.g. state or province abbreviation such as WA (Washington).
     */
    @JsonProperty(value = "abbreviatedName", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private String abbreviatedName;

    /**
     * Get the localizedName property: Represents the localized name of the administrative division of the locality.
     * e.g. state or province localized name.
     *
     * @return the localizedName value.
     */
    public String getLocalizedName() {
        return this.localizedName;
    }

    /**
     * Get the abbreviatedName property: Represents the abbreviated name of the administrative division of the locality.
     * e.g. state or province abbreviation such as WA (Washington).
     *
     * @return the abbreviatedName value.
     */
    public String getAbbreviatedName() {
        return this.abbreviatedName;
    }
}
