// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The PhoneNumberCost model. */
@Immutable
public final class PhoneNumberCost {
    /*
     * The cost amount.
     */
    @JsonProperty(value = "amount", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private double amount;

    /*
     * The ISO 4217 currency code for the cost amount, e.g. USD.
     */
    @JsonProperty(value = "currencyCode", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private String currencyCode;

    /*
     * The frequency with which the cost gets billed.
     */
    @JsonProperty(value = "billingFrequency", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private BillingFrequency billingFrequency;

    /**
     * Get the amount property: The cost amount.
     *
     * @return the amount value.
     */
    public double getAmount() {
        return this.amount;
    }

    /**
     * Get the currencyCode property: The ISO 4217 currency code for the cost amount, e.g. USD.
     *
     * @return the currencyCode value.
     */
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    /**
     * Get the billingFrequency property: The frequency with which the cost gets billed.
     *
     * @return the billingFrequency value.
     */
    public BillingFrequency getBillingFrequency() {
        return this.billingFrequency;
    }
}
