// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The PhoneNumberLocality model. */
@Immutable
public final class PhoneNumberLocality {
    /*
     * Represents the localized name of the locality.
     */
    @JsonProperty(value = "localizedName", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private String localizedName;

    /*
     * Represents an administrative division. e.g. state or province.
     */
    @JsonProperty(value = "administrativeDivision", access = JsonProperty.Access.WRITE_ONLY)
    private PhoneNumberAdministrativeDivision administrativeDivision;

    /**
     * Get the localizedName property: Represents the localized name of the locality.
     *
     * @return the localizedName value.
     */
    public String getLocalizedName() {
        return this.localizedName;
    }

    /**
     * Get the administrativeDivision property: Represents an administrative division. e.g. state or province.
     *
     * @return the administrativeDivision value.
     */
    public PhoneNumberAdministrativeDivision getAdministrativeDivision() {
        return this.administrativeDivision;
    }
}
