// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** The PhoneNumberOperation model. */
@Immutable
public final class PhoneNumberOperation {
    /*
     * Status of operation.
     */
    @JsonProperty(value = "status", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private PhoneNumberOperationStatus status;

    /*
     * URL for retrieving the result of the operation, if any.
     */
    @JsonProperty(value = "resourceLocation", access = JsonProperty.Access.WRITE_ONLY)
    private String resourceLocation;

    /*
     * The date that the operation was created.
     */
    @JsonProperty(value = "createdDateTime", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdDateTime;

    /*
     * Id of operation.
     */
    @JsonProperty(value = "id", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /*
     * The type of operation, e.g. Search
     */
    @JsonProperty(value = "operationType", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private PhoneNumberOperationType operationType;

    /*
     * The most recent date that the operation was changed.
     */
    @JsonProperty(value = "lastActionDateTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastActionDateTime;

    /**
     * The PhoneNumberOperation model.
     * @param status The status property: Status of operation.
     * @param resourceLocation The resourceLocation property: URL for retrieving the result of the operation, if any.
     * @param createdDateTime The createdDateTime property: The date that the operation was created.
     * @param id The id property: Id of operation.
     * @param operationType The operationType property: The type of operation, e.g. Search.
     * @param lastActionDateTime The lastActionDateTime property: The most recent date that the operation was changed.
     */
    public PhoneNumberOperation(PhoneNumberOperationStatus status, String resourceLocation, OffsetDateTime createdDateTime, String id,
        PhoneNumberOperationType operationType, OffsetDateTime lastActionDateTime) {
        this.status = status;
        this.resourceLocation = resourceLocation;
        this.createdDateTime = createdDateTime;
        this.id = id;
        this.operationType = operationType;
        this.lastActionDateTime = lastActionDateTime;
    }

    /**
     * Get the status property: Status of operation.
     *
     * @return the status value.
     */
    public PhoneNumberOperationStatus getStatus() {
        return this.status;
    }

    /**
     * Get the resourceLocation property: URL for retrieving the result of the operation, if any.
     *
     * @return the resourceLocation value.
     */
    public String getResourceLocation() {
        return this.resourceLocation;
    }

    /**
     * Get the createdDateTime property: The date that the operation was created.
     *
     * @return the createdDateTime value.
     */
    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    /**
     * Get the id property: Id of operation.
     *
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Get the operationType property: The type of operation, e.g. Search.
     *
     * @return the operationType value.
     */
    public PhoneNumberOperationType getOperationType() {
        return this.operationType;
    }

    /**
     * Get the lastActionDateTime property: The most recent date that the operation was changed.
     *
     * @return the lastActionDateTime value.
     */
    public OffsetDateTime getLastActionDateTime() {
        return this.lastActionDateTime;
    }
}
