// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.siprouting.implementation;

import com.azure.communication.phonenumbers.siprouting.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.phonenumbers.siprouting.implementation.models.SipConfiguration;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in SipRoutings. */
public final class SipRoutingsImpl {
    /** The proxy service used to perform REST calls. */
    private final SipRoutingsService service;

    /** The service client containing this operation class. */
    private final SipRoutingAdminClientImpl client;

    /**
     * Initializes an instance of SipRoutingsImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    SipRoutingsImpl(SipRoutingAdminClientImpl client) {
        this.service =
                RestProxy.create(SipRoutingsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for SipRoutingAdminClientSipRoutings to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{endpoint}")
    @ServiceInterface(name = "SipRoutingAdminClien")
    public interface SipRoutingsService {
        @Get("/sip")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<SipConfiguration>> get(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Patch("/sip")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<SipConfiguration>> update(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/merge-patch+json") SipConfiguration body,
                @HeaderParam("Accept") String accept,
                Context context);
    }

    /**
     * Gets SIP configuration for resource.
     *
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sIP configuration for resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SipConfiguration>> getWithResponseAsync() {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context -> service.get(this.client.getEndpoint(), this.client.getApiVersion(), accept, context));
    }

    /**
     * Gets SIP configuration for resource.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sIP configuration for resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SipConfiguration>> getWithResponseAsync(Context context) {
        final String accept = "application/json";
        return service.get(this.client.getEndpoint(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets SIP configuration for resource.
     *
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sIP configuration for resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SipConfiguration> getAsync() {
        return getWithResponseAsync()
                .flatMap(
                        (Response<SipConfiguration> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Gets SIP configuration for resource.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sIP configuration for resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SipConfiguration> getAsync(Context context) {
        return getWithResponseAsync(context)
                .flatMap(
                        (Response<SipConfiguration> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Gets SIP configuration for resource.
     *
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sIP configuration for resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SipConfiguration get() {
        return getAsync().block();
    }

    /**
     * Gets SIP configuration for resource.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return sIP configuration for resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SipConfiguration> getWithResponse(Context context) {
        return getWithResponseAsync(context).block();
    }

    /**
     * Updates SIP configuration for resource.
     *
     * @param body Sip configuration update object.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a SIP configuration. When a call is being routed the routes are applied in the same order as
     *     in the routes list. A route is matched by its number pattern. Call is then directed into route's first
     *     available trunk, based on the order in the route's trunks list.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SipConfiguration>> updateWithResponseAsync(SipConfiguration body) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.update(this.client.getEndpoint(), this.client.getApiVersion(), body, accept, context));
    }

    /**
     * Updates SIP configuration for resource.
     *
     * @param body Sip configuration update object.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a SIP configuration. When a call is being routed the routes are applied in the same order as
     *     in the routes list. A route is matched by its number pattern. Call is then directed into route's first
     *     available trunk, based on the order in the route's trunks list.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SipConfiguration>> updateWithResponseAsync(SipConfiguration body, Context context) {
        final String accept = "application/json";
        return service.update(this.client.getEndpoint(), this.client.getApiVersion(), body, accept, context);
    }

    /**
     * Updates SIP configuration for resource.
     *
     * @param body Sip configuration update object.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a SIP configuration. When a call is being routed the routes are applied in the same order as
     *     in the routes list. A route is matched by its number pattern. Call is then directed into route's first
     *     available trunk, based on the order in the route's trunks list.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SipConfiguration> updateAsync(SipConfiguration body) {
        return updateWithResponseAsync(body)
                .flatMap(
                        (Response<SipConfiguration> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Updates SIP configuration for resource.
     *
     * @param body Sip configuration update object.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a SIP configuration. When a call is being routed the routes are applied in the same order as
     *     in the routes list. A route is matched by its number pattern. Call is then directed into route's first
     *     available trunk, based on the order in the route's trunks list.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SipConfiguration> updateAsync(SipConfiguration body, Context context) {
        return updateWithResponseAsync(body, context)
                .flatMap(
                        (Response<SipConfiguration> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Updates SIP configuration for resource.
     *
     * @param body Sip configuration update object.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a SIP configuration. When a call is being routed the routes are applied in the same order as
     *     in the routes list. A route is matched by its number pattern. Call is then directed into route's first
     *     available trunk, based on the order in the route's trunks list.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SipConfiguration update(SipConfiguration body) {
        return updateAsync(body).block();
    }

    /**
     * Updates SIP configuration for resource.
     *
     * @param body Sip configuration update object.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a SIP configuration. When a call is being routed the routes are applied in the same order as
     *     in the routes list. A route is matched by its number pattern. Call is then directed into route's first
     *     available trunk, based on the order in the route's trunks list.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SipConfiguration> updateWithResponse(SipConfiguration body, Context context) {
        return updateWithResponseAsync(body, context).block();
    }
}
