// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.implementation.models;

import com.azure.communication.phonenumbers.CodeCoverageAnnotation.Generated;
import com.azure.communication.phonenumbers.models.PhoneNumberCapabilityType;
import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Capabilities of a phone number. */
@Fluent
@Generated
public final class PhoneNumberCapabilitiesRequest {
    /*
     * Capability value for calling.
     */
    @JsonProperty(value = "calling")
    private PhoneNumberCapabilityType calling;

    /*
     * Capability value for SMS.
     */
    @JsonProperty(value = "sms")
    private PhoneNumberCapabilityType sms;

    /**
     * Get the calling property: Capability value for calling.
     *
     * @return the calling value.
     */
    public PhoneNumberCapabilityType getCalling() {
        return this.calling;
    }

    /**
     * Set the calling property: Capability value for calling.
     *
     * @param calling the calling value to set.
     * @return the PhoneNumberCapabilitiesRequest object itself.
     */
    public PhoneNumberCapabilitiesRequest setCalling(PhoneNumberCapabilityType calling) {
        this.calling = calling;
        return this;
    }

    /**
     * Get the sms property: Capability value for SMS.
     *
     * @return the sms value.
     */
    public PhoneNumberCapabilityType getSms() {
        return this.sms;
    }

    /**
     * Set the sms property: Capability value for SMS.
     *
     * @param sms the sms value to set.
     * @return the PhoneNumberCapabilitiesRequest object itself.
     */
    public PhoneNumberCapabilitiesRequest setSms(PhoneNumberCapabilityType sms) {
        this.sms = sms;
        return this;
    }
}
