// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Represents metadata about a phone number that is controlled/provided by that phone number's operator. */
@Immutable
public final class OperatorInformation {
    /*
     * E.164 formatted string representation of the phone number
     */
    @JsonProperty(value = "phoneNumber", access = JsonProperty.Access.WRITE_ONLY)
    private String phoneNumber;

    /*
     * Type of service associated with the phone number
     */
    @JsonProperty(value = "numberType", access = JsonProperty.Access.WRITE_ONLY)
    private OperatorNumberType numberType;

    /*
     * ISO 3166-1 two character ('alpha-2') code associated with the phone
     * number.
     */
    @JsonProperty(value = "isoCountryCode", access = JsonProperty.Access.WRITE_ONLY)
    private String isoCountryCode;

    /*
     * Represents metadata describing the operator of a phone number
     */
    @JsonProperty(value = "operatorDetails", access = JsonProperty.Access.WRITE_ONLY)
    private OperatorDetails operatorDetails;

    /**
     * Get the phoneNumber property: E.164 formatted string representation of the phone number.
     *
     * @return the phoneNumber value.
     */
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    /**
     * Get the numberType property: Type of service associated with the phone number.
     *
     * @return the numberType value.
     */
    public OperatorNumberType getNumberType() {
        return this.numberType;
    }

    /**
     * Get the isoCountryCode property: ISO 3166-1 two character ('alpha-2') code associated with the phone number.
     *
     * @return the isoCountryCode value.
     */
    public String getIsoCountryCode() {
        return this.isoCountryCode;
    }

    /**
     * Get the operatorDetails property: Represents metadata describing the operator of a phone number.
     *
     * @return the operatorDetails value.
     */
    public OperatorDetails getOperatorDetails() {
        return this.operatorDetails;
    }
}
