// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for OperatorNumberType. */
public final class OperatorNumberType extends ExpandableStringEnum<OperatorNumberType> {
    /** Static value unknown for OperatorNumberType. */
    public static final OperatorNumberType UNKNOWN = fromString("unknown");

    /** Static value other for OperatorNumberType. */
    public static final OperatorNumberType OTHER = fromString("other");

    /** Static value geographic for OperatorNumberType. */
    public static final OperatorNumberType GEOGRAPHIC = fromString("geographic");

    /** Static value mobile for OperatorNumberType. */
    public static final OperatorNumberType MOBILE = fromString("mobile");

    /**
     * Creates or finds a OperatorNumberType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding OperatorNumberType.
     */
    @JsonCreator
    public static OperatorNumberType fromString(String name) {
        return fromString(name, OperatorNumberType.class);
    }

    /**
     * Gets known OperatorNumberType values.
     *
     * @return known OperatorNumberType values.
     */
    public static Collection<OperatorNumberType> values() {
        return values(OperatorNumberType.class);
    }
}
