// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for PhoneNumberCapabilityType. */
public final class PhoneNumberCapabilityType extends ExpandableStringEnum<PhoneNumberCapabilityType> {
    /** Static value none for PhoneNumberCapabilityType. */
    public static final PhoneNumberCapabilityType NONE = fromString("none");

    /** Static value inbound for PhoneNumberCapabilityType. */
    public static final PhoneNumberCapabilityType INBOUND = fromString("inbound");

    /** Static value outbound for PhoneNumberCapabilityType. */
    public static final PhoneNumberCapabilityType OUTBOUND = fromString("outbound");

    /** Static value inbound+outbound for PhoneNumberCapabilityType. */
    public static final PhoneNumberCapabilityType INBOUND_OUTBOUND = fromString("inbound+outbound");

    /**
     * Creates or finds a PhoneNumberCapabilityType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding PhoneNumberCapabilityType.
     */
    @JsonCreator
    public static PhoneNumberCapabilityType fromString(String name) {
        return fromString(name, PhoneNumberCapabilityType.class);
    }

    /**
     * Gives a Collection of PhoneNumberCapabilityType
     *
     * @return known PhoneNumberCapabilityType values.
     */
    public static Collection<PhoneNumberCapabilityType> values() {
        return values(PhoneNumberCapabilityType.class);
    }
}
