// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for PhoneNumberOperationStatus. */
public final class PhoneNumberOperationStatus extends ExpandableStringEnum<PhoneNumberOperationStatus> {
    /** Static value notStarted for PhoneNumberOperationStatus. */
    public static final PhoneNumberOperationStatus NOT_STARTED = fromString("notStarted");

    /** Static value running for PhoneNumberOperationStatus. */
    public static final PhoneNumberOperationStatus RUNNING = fromString("running");

    /** Static value succeeded for PhoneNumberOperationStatus. */
    public static final PhoneNumberOperationStatus SUCCEEDED = fromString("succeeded");

    /** Static value failed for PhoneNumberOperationStatus. */
    public static final PhoneNumberOperationStatus FAILED = fromString("failed");

    /**
     * Creates or finds a PhoneNumberOperationStatus from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding PhoneNumberOperationStatus.
     */
    @JsonCreator
    public static PhoneNumberOperationStatus fromString(String name) {
        return fromString(name, PhoneNumberOperationStatus.class);
    }

    /**
     * Gets known PhoneNumberOperationStatus values.
     *
     * @return known PhoneNumberOperationStatus values.
     */
    public static Collection<PhoneNumberOperationStatus> values() {
        return values(PhoneNumberOperationStatus.class);
    }
}
