// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** The result of a phone number search operation. */
@Fluent
public final class PhoneNumberSearchResult {
    /*
     * The search id.
     */
    @JsonProperty(value = "searchId", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private String searchId;

    /*
     * The phone numbers that are available. Can be fewer than the desired
     * search quantity.
     */
    @JsonProperty(value = "phoneNumbers", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private List<String> phoneNumbers;

    /*
     * The phone number's type, e.g. geographic, or tollFree.
     */
    @JsonProperty(value = "phoneNumberType", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private PhoneNumberType phoneNumberType;

    /*
     * Phone number's assignment type.
     */
    @JsonProperty(value = "assignmentType", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private PhoneNumberAssignmentType assignmentType;

    /*
     * Capabilities of a phone number.
     */
    @JsonProperty(value = "capabilities", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private PhoneNumberCapabilities capabilities;

    /*
     * The incurred cost for a single phone number.
     */
    @JsonProperty(value = "cost", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private PhoneNumberCost cost;

    /*
     * The date that this search result expires and phone numbers are no longer
     * on hold. A search result expires in less than 15min, e.g.
     * 2020-11-19T16:31:49.048Z.
     */
    @JsonProperty(value = "searchExpiresBy", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime searchExpiresBy;

    /*
     * The error code of the search.
     */
    @JsonProperty(value = "errorCode")
    private Integer errorCode;

    /*
     * Mapping Error Messages to Codes
     */
    @JsonProperty(value = "error")
    private PhoneNumberSearchResultError error;

    /**
     * Get the searchId property: The search id.
     *
     * @return the searchId value.
     */
    public String getSearchId() {
        return this.searchId;
    }

    /**
     * Get the phoneNumbers property: The phone numbers that are available. Can be fewer than the desired search
     * quantity.
     *
     * @return the phoneNumbers value.
     */
    public List<String> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    /**
     * Get the phoneNumberType property: The phone number's type, e.g. geographic, or tollFree.
     *
     * @return the phoneNumberType value.
     */
    public PhoneNumberType getPhoneNumberType() {
        return this.phoneNumberType;
    }

    /**
     * Get the assignmentType property: Phone number's assignment type.
     *
     * @return the assignmentType value.
     */
    public PhoneNumberAssignmentType getAssignmentType() {
        return this.assignmentType;
    }

    /**
     * Get the capabilities property: Capabilities of a phone number.
     *
     * @return the capabilities value.
     */
    public PhoneNumberCapabilities getCapabilities() {
        return this.capabilities;
    }

    /**
     * Get the cost property: The incurred cost for a single phone number.
     *
     * @return the cost value.
     */
    public PhoneNumberCost getCost() {
        return this.cost;
    }

    /**
     * Get the searchExpiresBy property: The date that this search result expires and phone numbers are no longer on
     * hold. A search result expires in less than 15min, e.g. 2020-11-19T16:31:49.048Z.
     *
     * @return the searchExpiresBy value.
     */
    public OffsetDateTime getSearchExpiresBy() {
        return this.searchExpiresBy;
    }

    /**
     * Get the errorCode property: The error code of the search.
     *
     * @return the errorCode value.
     */
    public Integer getErrorCode() {
        return this.errorCode;
    }

    /**
     * Set the errorCode property: The error code of the search.
     *
     * @param errorCode the errorCode value to set.
     * @return the PhoneNumberSearchResult object itself.
     */
    public PhoneNumberSearchResult setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    /**
     * Get the error property: Mapping Error Messages to Codes.
     *
     * @return the error value.
     */
    public PhoneNumberSearchResultError getError() {
        return this.error;
    }

    /**
     * Set the error property: Mapping Error Messages to Codes.
     *
     * @param error the error value to set.
     * @return the PhoneNumberSearchResult object itself.
     */
    public PhoneNumberSearchResult setError(PhoneNumberSearchResultError error) {
        this.error = error;
        return this;
    }
}
