// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Represents a purchased phone number. */
@Immutable
public final class PurchasedPhoneNumber {
    /*
     * The id of the phone number, e.g. 11234567890.
     */
    @JsonProperty(value = "id", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /*
     * String of the E.164 format of the phone number, e.g. +11234567890.
     */
    @JsonProperty(value = "phoneNumber", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private String phoneNumber;

    /*
     * The ISO 3166-2 code of the phone number's country, e.g. US.
     */
    @JsonProperty(value = "countryCode", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private String countryCode;

    /*
     * The phone number's type, e.g. geographic, tollFree.
     */
    @JsonProperty(value = "phoneNumberType", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private PhoneNumberType phoneNumberType;

    /*
     * Capabilities of a phone number.
     */
    @JsonProperty(value = "capabilities", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private PhoneNumberCapabilities capabilities;

    /*
     * The assignment type of the phone number. A phone number can be assigned
     * to a person, or to an application.
     */
    @JsonProperty(value = "assignmentType", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private PhoneNumberAssignmentType assignmentType;

    /*
     * The date and time that the phone number was purchased.
     */
    @JsonProperty(value = "purchaseDate", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime purchaseDate;

    /*
     * The incurred cost for a single phone number.
     */
    @JsonProperty(value = "cost", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private PhoneNumberCost cost;

    /**
     * Get the id property: The id of the phone number, e.g. 11234567890.
     *
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Get the phoneNumber property: String of the E.164 format of the phone number, e.g. +11234567890.
     *
     * @return the phoneNumber value.
     */
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    /**
     * Get the countryCode property: The ISO 3166-2 code of the phone number's country, e.g. US.
     *
     * @return the countryCode value.
     */
    public String getCountryCode() {
        return this.countryCode;
    }

    /**
     * Get the phoneNumberType property: The phone number's type, e.g. geographic, tollFree.
     *
     * @return the phoneNumberType value.
     */
    public PhoneNumberType getPhoneNumberType() {
        return this.phoneNumberType;
    }

    /**
     * Get the capabilities property: Capabilities of a phone number.
     *
     * @return the capabilities value.
     */
    public PhoneNumberCapabilities getCapabilities() {
        return this.capabilities;
    }

    /**
     * Get the assignmentType property: The assignment type of the phone number. A phone number can be assigned to a
     * person, or to an application.
     *
     * @return the assignmentType value.
     */
    public PhoneNumberAssignmentType getAssignmentType() {
        return this.assignmentType;
    }

    /**
     * Get the purchaseDate property: The date and time that the phone number was purchased.
     *
     * @return the purchaseDate value.
     */
    public OffsetDateTime getPurchaseDate() {
        return this.purchaseDate;
    }

    /**
     * Get the cost property: The incurred cost for a single phone number.
     *
     * @return the cost value.
     */
    public PhoneNumberCost getCost() {
        return this.cost;
    }
}
