// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.phonenumbers.siprouting.models;

import com.azure.core.annotation.Fluent;

import java.util.List;

/** Represents a trunk route for routing calls. */
@Fluent
public final class SipTrunkRoute {

    /*
     * Gets or sets description of the route.
     */
    private String description;

    /*
     * Gets or sets name of the route.
     */
    private final String name;

    /*
     * Gets or sets regex number pattern for routing calls. .NET regex format
     * is supported.
     * The regex should match only digits with an optional '+' prefix without
     * spaces.
     * I.e. "^\+[1-9][0-9]{3,23}$".
     */
    private final String numberPattern;

    /*
     * Gets or sets list of SIP trunks for routing calls. Trunks are
     * represented as FQDN.
     */
    private List<String> trunks;

    /**
     * Constructor with required properties.
     * @param name the name of the route.
     * @param numberPattern the regex number pattern for routing calls.
     */
    public SipTrunkRoute(String name, String numberPattern) {
        this.name = name;
        this.numberPattern = numberPattern;
    }

    /**
     * Get the description property: Gets or sets description of the route.
     *
     * @return the description value.
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: Gets or sets description of the route.
     *
     * @param description the description value to set.
     * @return the SipTrunkRoute object itself.
     */
    public SipTrunkRoute setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the name property: Gets or sets name of the route.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Get the numberPattern property: Gets or sets regex number pattern for routing calls. .NET regex format is
     * supported. The regex should match only digits with an optional '+' prefix without spaces. I.e.
     * "^\+[1-9][0-9]{3,23}$".
     *
     * @return the numberPattern value.
     */
    public String getNumberPattern() {
        return this.numberPattern;
    }

    /**
     * Get the trunks property: Gets or sets list of SIP trunks for routing calls. Trunks are represented as FQDN.
     *
     * @return the trunks value.
     */
    public List<String> getTrunks() {
        return this.trunks;
    }

    /**
     * Set the trunks property: Gets or sets list of SIP trunks for routing calls. Trunks are represented as FQDN.
     *
     * @param trunks the trunks value to set.
     * @return the SipTrunkRoute object itself.
     */
    public SipTrunkRoute setTrunks(List<String> trunks) {
        this.trunks = trunks;
        return this;
    }
}
