/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.phonenumbers.implementation;

import com.azure.communication.phonenumbers.implementation.PhoneNumberAdminClientImpl;
import com.azure.communication.phonenumbers.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.phonenumbers.implementation.models.OfferingsResponse;
import com.azure.communication.phonenumbers.implementation.models.OperatorInformationRequest;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberAreaCodes;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberCapabilitiesRequest;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberCountries;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberLocalities;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberPurchaseRequest;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberRawOperation;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumberSearchRequest;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersGetOperationResponse;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersPurchasePhoneNumbersResponse;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersReleasePhoneNumberResponse;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersSearchAvailablePhoneNumbersResponse;
import com.azure.communication.phonenumbers.implementation.models.PhoneNumbersUpdateCapabilitiesResponse;
import com.azure.communication.phonenumbers.implementation.models.PurchasedPhoneNumbers;
import com.azure.communication.phonenumbers.models.OperatorInformationResult;
import com.azure.communication.phonenumbers.models.PhoneNumberAreaCode;
import com.azure.communication.phonenumbers.models.PhoneNumberAssignmentType;
import com.azure.communication.phonenumbers.models.PhoneNumberCountry;
import com.azure.communication.phonenumbers.models.PhoneNumberLocality;
import com.azure.communication.phonenumbers.models.PhoneNumberOffering;
import com.azure.communication.phonenumbers.models.PhoneNumberSearchResult;
import com.azure.communication.phonenumbers.models.PhoneNumberType;
import com.azure.communication.phonenumbers.models.PurchasedPhoneNumber;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class PhoneNumbersImpl {
    private final PhoneNumbersService service;
    private final PhoneNumberAdminClientImpl client;

    PhoneNumbersImpl(PhoneNumberAdminClientImpl client) {
        this.service = (PhoneNumbersService)RestProxy.create(PhoneNumbersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberAreaCode>> listAreaCodesSinglePageAsync(String countryCode, PhoneNumberType phoneNumberType, Integer skip, Integer maxPageSize, PhoneNumberAssignmentType assignmentType, String locality, String administrativeDivision, String acceptLanguage) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAreaCodes(this.client.getEndpoint(), countryCode, phoneNumberType, skip, maxPageSize, assignmentType, locality, administrativeDivision, this.client.getApiVersion(), acceptLanguage, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumberAreaCodes)res.getValue()).getAreaCodes(), ((PhoneNumberAreaCodes)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberAreaCode>> listAreaCodesSinglePageAsync(String countryCode, PhoneNumberType phoneNumberType, Integer skip, Integer maxPageSize, PhoneNumberAssignmentType assignmentType, String locality, String administrativeDivision, String acceptLanguage, Context context) {
        String accept = "application/json";
        return this.service.listAreaCodes(this.client.getEndpoint(), countryCode, phoneNumberType, skip, maxPageSize, assignmentType, locality, administrativeDivision, this.client.getApiVersion(), acceptLanguage, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumberAreaCodes)res.getValue()).getAreaCodes(), ((PhoneNumberAreaCodes)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberAreaCode> listAreaCodesAsync(String countryCode, PhoneNumberType phoneNumberType, Integer skip, Integer maxPageSize, PhoneNumberAssignmentType assignmentType, String locality, String administrativeDivision, String acceptLanguage) {
        return new PagedFlux(() -> this.listAreaCodesSinglePageAsync(countryCode, phoneNumberType, skip, maxPageSize, assignmentType, locality, administrativeDivision, acceptLanguage), nextLink -> this.listAreaCodesNextSinglePageAsync((String)nextLink, acceptLanguage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberAreaCode> listAreaCodesAsync(String countryCode, PhoneNumberType phoneNumberType, Integer skip, Integer maxPageSize, PhoneNumberAssignmentType assignmentType, String locality, String administrativeDivision, String acceptLanguage, Context context) {
        return new PagedFlux(() -> this.listAreaCodesSinglePageAsync(countryCode, phoneNumberType, skip, maxPageSize, assignmentType, locality, administrativeDivision, acceptLanguage, context), nextLink -> this.listAreaCodesNextSinglePageAsync((String)nextLink, acceptLanguage, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberAreaCode> listAreaCodes(String countryCode, PhoneNumberType phoneNumberType, Integer skip, Integer maxPageSize, PhoneNumberAssignmentType assignmentType, String locality, String administrativeDivision, String acceptLanguage) {
        return new PagedIterable(this.listAreaCodesAsync(countryCode, phoneNumberType, skip, maxPageSize, assignmentType, locality, administrativeDivision, acceptLanguage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberAreaCode> listAreaCodes(String countryCode, PhoneNumberType phoneNumberType, Integer skip, Integer maxPageSize, PhoneNumberAssignmentType assignmentType, String locality, String administrativeDivision, String acceptLanguage, Context context) {
        return new PagedIterable(this.listAreaCodesAsync(countryCode, phoneNumberType, skip, maxPageSize, assignmentType, locality, administrativeDivision, acceptLanguage, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberCountry>> listAvailableCountriesSinglePageAsync(Integer skip, Integer maxPageSize, String acceptLanguage) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAvailableCountries(this.client.getEndpoint(), skip, maxPageSize, this.client.getApiVersion(), acceptLanguage, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumberCountries)res.getValue()).getCountries(), ((PhoneNumberCountries)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberCountry>> listAvailableCountriesSinglePageAsync(Integer skip, Integer maxPageSize, String acceptLanguage, Context context) {
        String accept = "application/json";
        return this.service.listAvailableCountries(this.client.getEndpoint(), skip, maxPageSize, this.client.getApiVersion(), acceptLanguage, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumberCountries)res.getValue()).getCountries(), ((PhoneNumberCountries)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberCountry> listAvailableCountriesAsync(Integer skip, Integer maxPageSize, String acceptLanguage) {
        return new PagedFlux(() -> this.listAvailableCountriesSinglePageAsync(skip, maxPageSize, acceptLanguage), nextLink -> this.listAvailableCountriesNextSinglePageAsync((String)nextLink, acceptLanguage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberCountry> listAvailableCountriesAsync(Integer skip, Integer maxPageSize, String acceptLanguage, Context context) {
        return new PagedFlux(() -> this.listAvailableCountriesSinglePageAsync(skip, maxPageSize, acceptLanguage, context), nextLink -> this.listAvailableCountriesNextSinglePageAsync((String)nextLink, acceptLanguage, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberCountry> listAvailableCountries(Integer skip, Integer maxPageSize, String acceptLanguage) {
        return new PagedIterable(this.listAvailableCountriesAsync(skip, maxPageSize, acceptLanguage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberCountry> listAvailableCountries(Integer skip, Integer maxPageSize, String acceptLanguage, Context context) {
        return new PagedIterable(this.listAvailableCountriesAsync(skip, maxPageSize, acceptLanguage, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberLocality>> listAvailableLocalitiesSinglePageAsync(String countryCode, Integer skip, Integer maxPageSize, String administrativeDivision, String acceptLanguage) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAvailableLocalities(this.client.getEndpoint(), countryCode, skip, maxPageSize, administrativeDivision, this.client.getApiVersion(), acceptLanguage, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumberLocalities)res.getValue()).getPhoneNumberLocalities(), ((PhoneNumberLocalities)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberLocality>> listAvailableLocalitiesSinglePageAsync(String countryCode, Integer skip, Integer maxPageSize, String administrativeDivision, String acceptLanguage, Context context) {
        String accept = "application/json";
        return this.service.listAvailableLocalities(this.client.getEndpoint(), countryCode, skip, maxPageSize, administrativeDivision, this.client.getApiVersion(), acceptLanguage, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumberLocalities)res.getValue()).getPhoneNumberLocalities(), ((PhoneNumberLocalities)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberLocality> listAvailableLocalitiesAsync(String countryCode, Integer skip, Integer maxPageSize, String administrativeDivision, String acceptLanguage) {
        return new PagedFlux(() -> this.listAvailableLocalitiesSinglePageAsync(countryCode, skip, maxPageSize, administrativeDivision, acceptLanguage), nextLink -> this.listAvailableLocalitiesNextSinglePageAsync((String)nextLink, acceptLanguage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberLocality> listAvailableLocalitiesAsync(String countryCode, Integer skip, Integer maxPageSize, String administrativeDivision, String acceptLanguage, Context context) {
        return new PagedFlux(() -> this.listAvailableLocalitiesSinglePageAsync(countryCode, skip, maxPageSize, administrativeDivision, acceptLanguage, context), nextLink -> this.listAvailableLocalitiesNextSinglePageAsync((String)nextLink, acceptLanguage, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberLocality> listAvailableLocalities(String countryCode, Integer skip, Integer maxPageSize, String administrativeDivision, String acceptLanguage) {
        return new PagedIterable(this.listAvailableLocalitiesAsync(countryCode, skip, maxPageSize, administrativeDivision, acceptLanguage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberLocality> listAvailableLocalities(String countryCode, Integer skip, Integer maxPageSize, String administrativeDivision, String acceptLanguage, Context context) {
        return new PagedIterable(this.listAvailableLocalitiesAsync(countryCode, skip, maxPageSize, administrativeDivision, acceptLanguage, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberOffering>> listOfferingsSinglePageAsync(String countryCode, Integer skip, Integer maxPageSize, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, String acceptLanguage) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listOfferings(this.client.getEndpoint(), countryCode, skip, maxPageSize, phoneNumberType, assignmentType, this.client.getApiVersion(), acceptLanguage, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OfferingsResponse)res.getValue()).getPhoneNumberOfferings(), ((OfferingsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberOffering>> listOfferingsSinglePageAsync(String countryCode, Integer skip, Integer maxPageSize, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, String acceptLanguage, Context context) {
        String accept = "application/json";
        return this.service.listOfferings(this.client.getEndpoint(), countryCode, skip, maxPageSize, phoneNumberType, assignmentType, this.client.getApiVersion(), acceptLanguage, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OfferingsResponse)res.getValue()).getPhoneNumberOfferings(), ((OfferingsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberOffering> listOfferingsAsync(String countryCode, Integer skip, Integer maxPageSize, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, String acceptLanguage) {
        return new PagedFlux(() -> this.listOfferingsSinglePageAsync(countryCode, skip, maxPageSize, phoneNumberType, assignmentType, acceptLanguage), nextLink -> this.listOfferingsNextSinglePageAsync((String)nextLink, acceptLanguage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PhoneNumberOffering> listOfferingsAsync(String countryCode, Integer skip, Integer maxPageSize, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, String acceptLanguage, Context context) {
        return new PagedFlux(() -> this.listOfferingsSinglePageAsync(countryCode, skip, maxPageSize, phoneNumberType, assignmentType, acceptLanguage, context), nextLink -> this.listOfferingsNextSinglePageAsync((String)nextLink, acceptLanguage, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberOffering> listOfferings(String countryCode, Integer skip, Integer maxPageSize, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, String acceptLanguage) {
        return new PagedIterable(this.listOfferingsAsync(countryCode, skip, maxPageSize, phoneNumberType, assignmentType, acceptLanguage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PhoneNumberOffering> listOfferings(String countryCode, Integer skip, Integer maxPageSize, PhoneNumberType phoneNumberType, PhoneNumberAssignmentType assignmentType, String acceptLanguage, Context context) {
        return new PagedIterable(this.listOfferingsAsync(countryCode, skip, maxPageSize, phoneNumberType, assignmentType, acceptLanguage, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersSearchAvailablePhoneNumbersResponse> searchAvailablePhoneNumbersWithResponseAsync(String countryCode, PhoneNumberSearchRequest body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.searchAvailablePhoneNumbers(this.client.getEndpoint(), countryCode, this.client.getApiVersion(), body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersSearchAvailablePhoneNumbersResponse> searchAvailablePhoneNumbersWithResponseAsync(String countryCode, PhoneNumberSearchRequest body, Context context) {
        String accept = "application/json";
        return this.service.searchAvailablePhoneNumbers(this.client.getEndpoint(), countryCode, this.client.getApiVersion(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumberSearchResult> searchAvailablePhoneNumbersAsync(String countryCode, PhoneNumberSearchRequest body) {
        return this.searchAvailablePhoneNumbersWithResponseAsync(countryCode, body).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumberSearchResult> searchAvailablePhoneNumbersAsync(String countryCode, PhoneNumberSearchRequest body, Context context) {
        return this.searchAvailablePhoneNumbersWithResponseAsync(countryCode, body, context).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PhoneNumberSearchResult searchAvailablePhoneNumbers(String countryCode, PhoneNumberSearchRequest body) {
        return (PhoneNumberSearchResult)this.searchAvailablePhoneNumbersAsync(countryCode, body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PhoneNumbersSearchAvailablePhoneNumbersResponse searchAvailablePhoneNumbersWithResponse(String countryCode, PhoneNumberSearchRequest body, Context context) {
        return (PhoneNumbersSearchAvailablePhoneNumbersResponse)((Object)this.searchAvailablePhoneNumbersWithResponseAsync(countryCode, body, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PhoneNumberSearchResult>> getSearchResultWithResponseAsync(String searchId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSearchResult(this.client.getEndpoint(), searchId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PhoneNumberSearchResult>> getSearchResultWithResponseAsync(String searchId, Context context) {
        String accept = "application/json";
        return this.service.getSearchResult(this.client.getEndpoint(), searchId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumberSearchResult> getSearchResultAsync(String searchId) {
        return this.getSearchResultWithResponseAsync(searchId).flatMap(res -> Mono.justOrEmpty((Object)((PhoneNumberSearchResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumberSearchResult> getSearchResultAsync(String searchId, Context context) {
        return this.getSearchResultWithResponseAsync(searchId, context).flatMap(res -> Mono.justOrEmpty((Object)((PhoneNumberSearchResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PhoneNumberSearchResult getSearchResult(String searchId) {
        return (PhoneNumberSearchResult)this.getSearchResultAsync(searchId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PhoneNumberSearchResult> getSearchResultWithResponse(String searchId, Context context) {
        return (Response)this.getSearchResultWithResponseAsync(searchId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersPurchasePhoneNumbersResponse> purchasePhoneNumbersWithResponseAsync(PhoneNumberPurchaseRequest body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.purchasePhoneNumbers(this.client.getEndpoint(), this.client.getApiVersion(), body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersPurchasePhoneNumbersResponse> purchasePhoneNumbersWithResponseAsync(PhoneNumberPurchaseRequest body, Context context) {
        String accept = "application/json";
        return this.service.purchasePhoneNumbers(this.client.getEndpoint(), this.client.getApiVersion(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purchasePhoneNumbersAsync(PhoneNumberPurchaseRequest body) {
        return this.purchasePhoneNumbersWithResponseAsync(body).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purchasePhoneNumbersAsync(PhoneNumberPurchaseRequest body, Context context) {
        return this.purchasePhoneNumbersWithResponseAsync(body, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purchasePhoneNumbers(PhoneNumberPurchaseRequest body) {
        this.purchasePhoneNumbersAsync(body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PhoneNumbersPurchasePhoneNumbersResponse purchasePhoneNumbersWithResponse(PhoneNumberPurchaseRequest body, Context context) {
        return (PhoneNumbersPurchasePhoneNumbersResponse)((Object)this.purchasePhoneNumbersWithResponseAsync(body, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersGetOperationResponse> getOperationWithResponseAsync(String operationId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getOperation(this.client.getEndpoint(), operationId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersGetOperationResponse> getOperationWithResponseAsync(String operationId, Context context) {
        String accept = "application/json";
        return this.service.getOperation(this.client.getEndpoint(), operationId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumberRawOperation> getOperationAsync(String operationId) {
        return this.getOperationWithResponseAsync(operationId).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumberRawOperation> getOperationAsync(String operationId, Context context) {
        return this.getOperationWithResponseAsync(operationId, context).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PhoneNumberRawOperation getOperation(String operationId) {
        return (PhoneNumberRawOperation)this.getOperationAsync(operationId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PhoneNumbersGetOperationResponse getOperationWithResponse(String operationId, Context context) {
        return (PhoneNumbersGetOperationResponse)((Object)this.getOperationWithResponseAsync(operationId, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelOperationWithResponseAsync(String operationId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancelOperation(this.client.getEndpoint(), operationId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelOperationWithResponseAsync(String operationId, Context context) {
        String accept = "application/json";
        return this.service.cancelOperation(this.client.getEndpoint(), operationId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelOperationAsync(String operationId) {
        return this.cancelOperationWithResponseAsync(operationId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelOperationAsync(String operationId, Context context) {
        return this.cancelOperationWithResponseAsync(operationId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelOperation(String operationId) {
        this.cancelOperationAsync(operationId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelOperationWithResponse(String operationId, Context context) {
        return (Response)this.cancelOperationWithResponseAsync(operationId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersUpdateCapabilitiesResponse> updateCapabilitiesWithResponseAsync(String phoneNumber, PhoneNumberCapabilitiesRequest body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateCapabilities(this.client.getEndpoint(), phoneNumber, this.client.getApiVersion(), body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersUpdateCapabilitiesResponse> updateCapabilitiesWithResponseAsync(String phoneNumber, PhoneNumberCapabilitiesRequest body, Context context) {
        String accept = "application/json";
        return this.service.updateCapabilities(this.client.getEndpoint(), phoneNumber, this.client.getApiVersion(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PurchasedPhoneNumber> updateCapabilitiesAsync(String phoneNumber, PhoneNumberCapabilitiesRequest body) {
        return this.updateCapabilitiesWithResponseAsync(phoneNumber, body).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PurchasedPhoneNumber> updateCapabilitiesAsync(String phoneNumber, PhoneNumberCapabilitiesRequest body, Context context) {
        return this.updateCapabilitiesWithResponseAsync(phoneNumber, body, context).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PurchasedPhoneNumber updateCapabilities(String phoneNumber, PhoneNumberCapabilitiesRequest body) {
        return (PurchasedPhoneNumber)this.updateCapabilitiesAsync(phoneNumber, body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PhoneNumbersUpdateCapabilitiesResponse updateCapabilitiesWithResponse(String phoneNumber, PhoneNumberCapabilitiesRequest body, Context context) {
        return (PhoneNumbersUpdateCapabilitiesResponse)((Object)this.updateCapabilitiesWithResponseAsync(phoneNumber, body, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PurchasedPhoneNumber>> getByNumberWithResponseAsync(String phoneNumber) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByNumber(this.client.getEndpoint(), phoneNumber, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PurchasedPhoneNumber>> getByNumberWithResponseAsync(String phoneNumber, Context context) {
        String accept = "application/json";
        return this.service.getByNumber(this.client.getEndpoint(), phoneNumber, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PurchasedPhoneNumber> getByNumberAsync(String phoneNumber) {
        return this.getByNumberWithResponseAsync(phoneNumber).flatMap(res -> Mono.justOrEmpty((Object)((PurchasedPhoneNumber)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PurchasedPhoneNumber> getByNumberAsync(String phoneNumber, Context context) {
        return this.getByNumberWithResponseAsync(phoneNumber, context).flatMap(res -> Mono.justOrEmpty((Object)((PurchasedPhoneNumber)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PurchasedPhoneNumber getByNumber(String phoneNumber) {
        return (PurchasedPhoneNumber)this.getByNumberAsync(phoneNumber).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PurchasedPhoneNumber> getByNumberWithResponse(String phoneNumber, Context context) {
        return (Response)this.getByNumberWithResponseAsync(phoneNumber, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersReleasePhoneNumberResponse> releasePhoneNumberWithResponseAsync(String phoneNumber) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.releasePhoneNumber(this.client.getEndpoint(), phoneNumber, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PhoneNumbersReleasePhoneNumberResponse> releasePhoneNumberWithResponseAsync(String phoneNumber, Context context) {
        String accept = "application/json";
        return this.service.releasePhoneNumber(this.client.getEndpoint(), phoneNumber, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> releasePhoneNumberAsync(String phoneNumber) {
        return this.releasePhoneNumberWithResponseAsync(phoneNumber).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> releasePhoneNumberAsync(String phoneNumber, Context context) {
        return this.releasePhoneNumberWithResponseAsync(phoneNumber, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void releasePhoneNumber(String phoneNumber) {
        this.releasePhoneNumberAsync(phoneNumber).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PhoneNumbersReleasePhoneNumberResponse releasePhoneNumberWithResponse(String phoneNumber, Context context) {
        return (PhoneNumbersReleasePhoneNumberResponse)((Object)this.releasePhoneNumberWithResponseAsync(phoneNumber, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PurchasedPhoneNumber>> listPhoneNumbersSinglePageAsync(Integer skip, Integer top) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listPhoneNumbers(this.client.getEndpoint(), skip, top, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PurchasedPhoneNumbers)res.getValue()).getPhoneNumbers(), ((PurchasedPhoneNumbers)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PurchasedPhoneNumber>> listPhoneNumbersSinglePageAsync(Integer skip, Integer top, Context context) {
        String accept = "application/json";
        return this.service.listPhoneNumbers(this.client.getEndpoint(), skip, top, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PurchasedPhoneNumbers)res.getValue()).getPhoneNumbers(), ((PurchasedPhoneNumbers)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PurchasedPhoneNumber> listPhoneNumbersAsync(Integer skip, Integer top) {
        return new PagedFlux(() -> this.listPhoneNumbersSinglePageAsync(skip, top), nextLink -> this.listPhoneNumbersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PurchasedPhoneNumber> listPhoneNumbersAsync(Integer skip, Integer top, Context context) {
        return new PagedFlux(() -> this.listPhoneNumbersSinglePageAsync(skip, top, context), nextLink -> this.listPhoneNumbersNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PurchasedPhoneNumber> listPhoneNumbers(Integer skip, Integer top) {
        return new PagedIterable(this.listPhoneNumbersAsync(skip, top));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PurchasedPhoneNumber> listPhoneNumbers(Integer skip, Integer top, Context context) {
        return new PagedIterable(this.listPhoneNumbersAsync(skip, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<OperatorInformationResult>> operatorInformationSearchWithResponseAsync(OperatorInformationRequest body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.operatorInformationSearch(this.client.getEndpoint(), this.client.getApiVersion(), body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<OperatorInformationResult>> operatorInformationSearchWithResponseAsync(OperatorInformationRequest body, Context context) {
        String accept = "application/json";
        return this.service.operatorInformationSearch(this.client.getEndpoint(), this.client.getApiVersion(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OperatorInformationResult> operatorInformationSearchAsync(OperatorInformationRequest body) {
        return this.operatorInformationSearchWithResponseAsync(body).flatMap(res -> Mono.justOrEmpty((Object)((OperatorInformationResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OperatorInformationResult> operatorInformationSearchAsync(OperatorInformationRequest body, Context context) {
        return this.operatorInformationSearchWithResponseAsync(body, context).flatMap(res -> Mono.justOrEmpty((Object)((OperatorInformationResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperatorInformationResult operatorInformationSearch(OperatorInformationRequest body) {
        return (OperatorInformationResult)this.operatorInformationSearchAsync(body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<OperatorInformationResult> operatorInformationSearchWithResponse(OperatorInformationRequest body, Context context) {
        return (Response)this.operatorInformationSearchWithResponseAsync(body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberAreaCode>> listAreaCodesNextSinglePageAsync(String nextLink, String acceptLanguage) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAreaCodesNext(nextLink, this.client.getEndpoint(), acceptLanguage, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumberAreaCodes)res.getValue()).getAreaCodes(), ((PhoneNumberAreaCodes)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberAreaCode>> listAreaCodesNextSinglePageAsync(String nextLink, String acceptLanguage, Context context) {
        String accept = "application/json";
        return this.service.listAreaCodesNext(nextLink, this.client.getEndpoint(), acceptLanguage, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumberAreaCodes)res.getValue()).getAreaCodes(), ((PhoneNumberAreaCodes)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberCountry>> listAvailableCountriesNextSinglePageAsync(String nextLink, String acceptLanguage) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAvailableCountriesNext(nextLink, this.client.getEndpoint(), acceptLanguage, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumberCountries)res.getValue()).getCountries(), ((PhoneNumberCountries)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberCountry>> listAvailableCountriesNextSinglePageAsync(String nextLink, String acceptLanguage, Context context) {
        String accept = "application/json";
        return this.service.listAvailableCountriesNext(nextLink, this.client.getEndpoint(), acceptLanguage, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumberCountries)res.getValue()).getCountries(), ((PhoneNumberCountries)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberLocality>> listAvailableLocalitiesNextSinglePageAsync(String nextLink, String acceptLanguage) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAvailableLocalitiesNext(nextLink, this.client.getEndpoint(), acceptLanguage, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumberLocalities)res.getValue()).getPhoneNumberLocalities(), ((PhoneNumberLocalities)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberLocality>> listAvailableLocalitiesNextSinglePageAsync(String nextLink, String acceptLanguage, Context context) {
        String accept = "application/json";
        return this.service.listAvailableLocalitiesNext(nextLink, this.client.getEndpoint(), acceptLanguage, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PhoneNumberLocalities)res.getValue()).getPhoneNumberLocalities(), ((PhoneNumberLocalities)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberOffering>> listOfferingsNextSinglePageAsync(String nextLink, String acceptLanguage) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listOfferingsNext(nextLink, this.client.getEndpoint(), acceptLanguage, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OfferingsResponse)res.getValue()).getPhoneNumberOfferings(), ((OfferingsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PhoneNumberOffering>> listOfferingsNextSinglePageAsync(String nextLink, String acceptLanguage, Context context) {
        String accept = "application/json";
        return this.service.listOfferingsNext(nextLink, this.client.getEndpoint(), acceptLanguage, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OfferingsResponse)res.getValue()).getPhoneNumberOfferings(), ((OfferingsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PurchasedPhoneNumber>> listPhoneNumbersNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listPhoneNumbersNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PurchasedPhoneNumbers)res.getValue()).getPhoneNumbers(), ((PurchasedPhoneNumbers)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PurchasedPhoneNumber>> listPhoneNumbersNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.listPhoneNumbersNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PurchasedPhoneNumbers)res.getValue()).getPhoneNumbers(), ((PurchasedPhoneNumbers)res.getValue()).getNextLink(), null));
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="PhoneNumberAdminClie")
    public static interface PhoneNumbersService {
        @Get(value="/availablePhoneNumbers/countries/{countryCode}/areaCodes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PhoneNumberAreaCodes>> listAreaCodes(@HostParam(value="endpoint") String var1, @PathParam(value="countryCode") String var2, @QueryParam(value="phoneNumberType") PhoneNumberType var3, @QueryParam(value="skip") Integer var4, @QueryParam(value="maxPageSize") Integer var5, @QueryParam(value="assignmentType") PhoneNumberAssignmentType var6, @QueryParam(value="locality") String var7, @QueryParam(value="administrativeDivision") String var8, @QueryParam(value="api-version") String var9, @HeaderParam(value="accept-language") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Get(value="/availablePhoneNumbers/countries")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PhoneNumberCountries>> listAvailableCountries(@HostParam(value="endpoint") String var1, @QueryParam(value="skip") Integer var2, @QueryParam(value="maxPageSize") Integer var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/availablePhoneNumbers/countries/{countryCode}/localities")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PhoneNumberLocalities>> listAvailableLocalities(@HostParam(value="endpoint") String var1, @PathParam(value="countryCode") String var2, @QueryParam(value="skip") Integer var3, @QueryParam(value="maxPageSize") Integer var4, @QueryParam(value="administrativeDivision") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="accept-language") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/availablePhoneNumbers/countries/{countryCode}/offerings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<OfferingsResponse>> listOfferings(@HostParam(value="endpoint") String var1, @PathParam(value="countryCode") String var2, @QueryParam(value="skip") Integer var3, @QueryParam(value="maxPageSize") Integer var4, @QueryParam(value="phoneNumberType") PhoneNumberType var5, @QueryParam(value="assignmentType") PhoneNumberAssignmentType var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="accept-language") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/availablePhoneNumbers/countries/{countryCode}/:search")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<PhoneNumbersSearchAvailablePhoneNumbersResponse> searchAvailablePhoneNumbers(@HostParam(value="endpoint") String var1, @PathParam(value="countryCode") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") PhoneNumberSearchRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/availablePhoneNumbers/searchResults/{searchId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PhoneNumberSearchResult>> getSearchResult(@HostParam(value="endpoint") String var1, @PathParam(value="searchId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/availablePhoneNumbers/:purchase")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<PhoneNumbersPurchasePhoneNumbersResponse> purchasePhoneNumbers(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") PhoneNumberPurchaseRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/phoneNumbers/operations/{operationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<PhoneNumbersGetOperationResponse> getOperation(@HostParam(value="endpoint") String var1, @PathParam(value="operationId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/phoneNumbers/operations/{operationId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> cancelOperation(@HostParam(value="endpoint") String var1, @PathParam(value="operationId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Patch(value="/phoneNumbers/{phoneNumber}/capabilities")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<PhoneNumbersUpdateCapabilitiesResponse> updateCapabilities(@HostParam(value="endpoint") String var1, @PathParam(value="phoneNumber") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/merge-patch+json") PhoneNumberCapabilitiesRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/phoneNumbers/{phoneNumber}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PurchasedPhoneNumber>> getByNumber(@HostParam(value="endpoint") String var1, @PathParam(value="phoneNumber") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/phoneNumbers/{phoneNumber}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<PhoneNumbersReleasePhoneNumberResponse> releasePhoneNumber(@HostParam(value="endpoint") String var1, @PathParam(value="phoneNumber") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/phoneNumbers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PurchasedPhoneNumbers>> listPhoneNumbers(@HostParam(value="endpoint") String var1, @QueryParam(value="skip") Integer var2, @QueryParam(value="top") Integer var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/operatorInformation/:search")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<OperatorInformationResult>> operatorInformationSearch(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") OperatorInformationRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PhoneNumberAreaCodes>> listAreaCodesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PhoneNumberCountries>> listAvailableCountriesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PhoneNumberLocalities>> listAvailableLocalitiesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<OfferingsResponse>> listOfferingsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="accept-language") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<PurchasedPhoneNumbers>> listPhoneNumbersNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

