/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.phonenumbers.siprouting.implementation;

import com.azure.communication.phonenumbers.siprouting.implementation.SipRoutingAdminClientImpl;
import com.azure.communication.phonenumbers.siprouting.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.phonenumbers.siprouting.implementation.models.SipConfiguration;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class SipRoutingsImpl {
    private final SipRoutingsService service;
    private final SipRoutingAdminClientImpl client;

    SipRoutingsImpl(SipRoutingAdminClientImpl client) {
        this.service = (SipRoutingsService)RestProxy.create(SipRoutingsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SipConfiguration>> getWithResponseAsync() {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SipConfiguration>> getWithResponseAsync(Context context) {
        String accept = "application/json";
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SipConfiguration> getAsync() {
        return this.getWithResponseAsync().flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SipConfiguration)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SipConfiguration> getAsync(Context context) {
        return this.getWithResponseAsync(context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SipConfiguration)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SipConfiguration get() {
        return (SipConfiguration)this.getAsync().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SipConfiguration> getWithResponse(Context context) {
        return (Response)this.getWithResponseAsync(context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SipConfiguration>> updateWithResponseAsync(SipConfiguration body) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), body, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SipConfiguration>> updateWithResponseAsync(SipConfiguration body, Context context) {
        String accept = "application/json";
        return this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SipConfiguration> updateAsync(SipConfiguration body) {
        return this.updateWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SipConfiguration)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SipConfiguration> updateAsync(SipConfiguration body, Context context) {
        return this.updateWithResponseAsync(body, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SipConfiguration)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SipConfiguration update(SipConfiguration body) {
        return (SipConfiguration)this.updateAsync(body).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SipConfiguration> updateWithResponse(SipConfiguration body, Context context) {
        return (Response)this.updateWithResponseAsync(body, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="SipRoutingAdminClien")
    public static interface SipRoutingsService {
        @Get(value="/sip")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<SipConfiguration>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Patch(value="/sip")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<SipConfiguration>> update(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/merge-patch+json") SipConfiguration var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

