/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.sms.implementation;

import com.azure.communication.sms.implementation.AzureCommunicationSMSServiceImpl;
import com.azure.communication.sms.implementation.models.SendMessageRequest;
import com.azure.communication.sms.implementation.models.SmsSendResponse;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import reactor.core.publisher.Mono;

public final class SmsImpl {
    private final SmsService service;
    private final AzureCommunicationSMSServiceImpl client;

    SmsImpl(AzureCommunicationSMSServiceImpl client) {
        this.service = (SmsService)RestProxy.create(SmsService.class, (HttpPipeline)client.getHttpPipeline());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SmsSendResponse>> sendWithResponseAsync(SendMessageRequest sendMessageRequest) {
        return FluxUtil.withContext(context -> this.service.send(this.client.getEndpoint(), this.client.getApiVersion(), sendMessageRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SmsSendResponse>> sendWithResponseAsync(SendMessageRequest sendMessageRequest, Context context) {
        return this.service.send(this.client.getEndpoint(), this.client.getApiVersion(), sendMessageRequest, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SmsSendResponse> sendAsync(SendMessageRequest sendMessageRequest) {
        return this.sendWithResponseAsync(sendMessageRequest).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SmsSendResponse)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SmsSendResponse> sendAsync(SendMessageRequest sendMessageRequest, Context context) {
        return this.sendWithResponseAsync(sendMessageRequest, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SmsSendResponse)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SmsSendResponse send(SendMessageRequest sendMessageRequest) {
        return (SmsSendResponse)this.sendAsync(sendMessageRequest).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SmsSendResponse send(SendMessageRequest sendMessageRequest, Context context) {
        return (SmsSendResponse)this.sendAsync(sendMessageRequest, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="AzureCommunicationSM")
    public static interface SmsService {
        @Post(value="/sms")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<SmsSendResponse>> send(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") SendMessageRequest var3, Context var4);
    }
}

