// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.containers.containerregistry.implementation;

import com.azure.containers.containerregistry.implementation.models.AcrErrorsException;
import com.azure.containers.containerregistry.implementation.models.AcrManifests;
import com.azure.containers.containerregistry.implementation.models.ArtifactManifestPropertiesInternal;
import com.azure.containers.containerregistry.implementation.models.ArtifactTagPropertiesInternal;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistriesCreateManifestHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistriesGetManifestsHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistriesGetManifestsNextHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistriesGetRepositoriesHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistriesGetRepositoriesNextHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistriesGetTagsHeaders;
import com.azure.containers.containerregistry.implementation.models.ContainerRegistriesGetTagsNextHeaders;
import com.azure.containers.containerregistry.implementation.models.DeleteRepositoryResult;
import com.azure.containers.containerregistry.implementation.models.ManifestAttributesBase;
import com.azure.containers.containerregistry.implementation.models.ManifestWriteableProperties;
import com.azure.containers.containerregistry.implementation.models.Repositories;
import com.azure.containers.containerregistry.implementation.models.RepositoryWriteableProperties;
import com.azure.containers.containerregistry.implementation.models.TagAttributesBase;
import com.azure.containers.containerregistry.implementation.models.TagList;
import com.azure.containers.containerregistry.implementation.models.TagWriteableProperties;
import com.azure.containers.containerregistry.models.ContainerRepositoryProperties;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ContainerRegistries. */
public final class ContainerRegistriesImpl {
    /** The proxy service used to perform REST calls. */
    private final ContainerRegistriesService service;

    /** The service client containing this operation class. */
    private final AzureContainerRegistryImpl client;

    /**
     * Initializes an instance of ContainerRegistriesImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    ContainerRegistriesImpl(AzureContainerRegistryImpl client) {
        this.service =
                RestProxy.create(
                        ContainerRegistriesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AzureContainerRegistryContainerRegistries to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{url}")
    @ServiceInterface(name = "AzureContainerRegist")
    public interface ContainerRegistriesService {
        @Get("/v2/")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<Response<Void>> checkDockerV2Support(
                @HostParam("url") String url, @HeaderParam("Accept") String accept, Context context);

        @Get("/v2/")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Response<Void> checkDockerV2SupportSync(
                @HostParam("url") String url, @HeaderParam("Accept") String accept, Context context);

        @Get("/v2/{name}/manifests/{reference}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<Response<BinaryData>> getManifest(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @PathParam("reference") String reference,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/v2/{name}/manifests/{reference}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Response<BinaryData> getManifestSync(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @PathParam("reference") String reference,
                @HeaderParam("Accept") String accept,
                Context context);

        @Put("/v2/{name}/manifests/{reference}")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<ResponseBase<ContainerRegistriesCreateManifestHeaders, Void>> createManifest(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @PathParam("reference") String reference,
                @HeaderParam("Content-Type") String contentType,
                @BodyParam("application/vnd.docker.distribution.manifest.v2+json") Flux<ByteBuffer> payload,
                @HeaderParam("Content-Length") long contentLength,
                @HeaderParam("Accept") String accept,
                Context context);

        @Put("/v2/{name}/manifests/{reference}")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<ResponseBase<ContainerRegistriesCreateManifestHeaders, Void>> createManifest(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @PathParam("reference") String reference,
                @HeaderParam("Content-Type") String contentType,
                @BodyParam("application/vnd.docker.distribution.manifest.v2+json") BinaryData payload,
                @HeaderParam("Content-Length") long contentLength,
                @HeaderParam("Accept") String accept,
                Context context);

        @Put("/v2/{name}/manifests/{reference}")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        ResponseBase<ContainerRegistriesCreateManifestHeaders, Void> createManifestSync(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @PathParam("reference") String reference,
                @HeaderParam("Content-Type") String contentType,
                @BodyParam("application/vnd.docker.distribution.manifest.v2+json") BinaryData payload,
                @HeaderParam("Content-Length") long contentLength,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/v2/{name}/manifests/{reference}")
        @ExpectedResponses({202, 404})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<Response<Void>> deleteManifest(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @PathParam("reference") String reference,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/v2/{name}/manifests/{reference}")
        @ExpectedResponses({202, 404})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Response<Void> deleteManifestSync(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @PathParam("reference") String reference,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/acr/v1/_catalog")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<ResponseBase<ContainerRegistriesGetRepositoriesHeaders, Repositories>> getRepositories(
                @HostParam("url") String url,
                @QueryParam("last") String last,
                @QueryParam("n") Integer n,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/acr/v1/_catalog")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        ResponseBase<ContainerRegistriesGetRepositoriesHeaders, Repositories> getRepositoriesSync(
                @HostParam("url") String url,
                @QueryParam("last") String last,
                @QueryParam("n") Integer n,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/acr/v1/{name}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<Response<ContainerRepositoryProperties>> getProperties(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/acr/v1/{name}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Response<ContainerRepositoryProperties> getPropertiesSync(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/acr/v1/{name}")
        @ExpectedResponses({202, 404})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<Response<DeleteRepositoryResult>> deleteRepository(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/acr/v1/{name}")
        @ExpectedResponses({202, 404})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Response<DeleteRepositoryResult> deleteRepositorySync(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Patch("/acr/v1/{name}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<Response<ContainerRepositoryProperties>> updateProperties(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") RepositoryWriteableProperties value,
                @HeaderParam("Accept") String accept,
                Context context);

        @Patch("/acr/v1/{name}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Response<ContainerRepositoryProperties> updatePropertiesSync(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") RepositoryWriteableProperties value,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/acr/v1/{name}/_tags")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<ResponseBase<ContainerRegistriesGetTagsHeaders, TagList>> getTags(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @QueryParam("last") String last,
                @QueryParam("n") Integer n,
                @QueryParam("orderby") String orderBy,
                @QueryParam("digest") String digest,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/acr/v1/{name}/_tags")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        ResponseBase<ContainerRegistriesGetTagsHeaders, TagList> getTagsSync(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @QueryParam("last") String last,
                @QueryParam("n") Integer n,
                @QueryParam("orderby") String orderBy,
                @QueryParam("digest") String digest,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/acr/v1/{name}/_tags/{reference}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<Response<ArtifactTagPropertiesInternal>> getTagProperties(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @PathParam("reference") String reference,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/acr/v1/{name}/_tags/{reference}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Response<ArtifactTagPropertiesInternal> getTagPropertiesSync(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @PathParam("reference") String reference,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Patch("/acr/v1/{name}/_tags/{reference}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<Response<ArtifactTagPropertiesInternal>> updateTagAttributes(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @PathParam("reference") String reference,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") TagWriteableProperties value,
                @HeaderParam("Accept") String accept,
                Context context);

        @Patch("/acr/v1/{name}/_tags/{reference}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Response<ArtifactTagPropertiesInternal> updateTagAttributesSync(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @PathParam("reference") String reference,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") TagWriteableProperties value,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/acr/v1/{name}/_tags/{reference}")
        @ExpectedResponses({202, 404})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<Response<Void>> deleteTag(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @PathParam("reference") String reference,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/acr/v1/{name}/_tags/{reference}")
        @ExpectedResponses({202, 404})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Response<Void> deleteTagSync(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @PathParam("reference") String reference,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/acr/v1/{name}/_manifests")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<ResponseBase<ContainerRegistriesGetManifestsHeaders, AcrManifests>> getManifests(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @QueryParam("last") String last,
                @QueryParam("n") Integer n,
                @QueryParam("orderby") String orderBy,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/acr/v1/{name}/_manifests")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        ResponseBase<ContainerRegistriesGetManifestsHeaders, AcrManifests> getManifestsSync(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @QueryParam("last") String last,
                @QueryParam("n") Integer n,
                @QueryParam("orderby") String orderBy,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/acr/v1/{name}/_manifests/{digest}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<Response<ArtifactManifestPropertiesInternal>> getManifestProperties(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @PathParam("digest") String digest,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/acr/v1/{name}/_manifests/{digest}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Response<ArtifactManifestPropertiesInternal> getManifestPropertiesSync(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @PathParam("digest") String digest,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Patch("/acr/v1/{name}/_manifests/{digest}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<Response<ArtifactManifestPropertiesInternal>> updateManifestProperties(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @PathParam("digest") String digest,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") ManifestWriteableProperties value,
                @HeaderParam("Accept") String accept,
                Context context);

        @Patch("/acr/v1/{name}/_manifests/{digest}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Response<ArtifactManifestPropertiesInternal> updateManifestPropertiesSync(
                @HostParam("url") String url,
                @PathParam("name") String name,
                @PathParam("digest") String digest,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") ManifestWriteableProperties value,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<ResponseBase<ContainerRegistriesGetRepositoriesNextHeaders, Repositories>> getRepositoriesNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("url") String url,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        ResponseBase<ContainerRegistriesGetRepositoriesNextHeaders, Repositories> getRepositoriesNextSync(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("url") String url,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<ResponseBase<ContainerRegistriesGetTagsNextHeaders, TagList>> getTagsNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("url") String url,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        ResponseBase<ContainerRegistriesGetTagsNextHeaders, TagList> getTagsNextSync(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("url") String url,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        Mono<ResponseBase<ContainerRegistriesGetManifestsNextHeaders, AcrManifests>> getManifestsNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("url") String url,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(AcrErrorsException.class)
        ResponseBase<ContainerRegistriesGetManifestsNextHeaders, AcrManifests> getManifestsNextSync(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("url") String url,
                @HeaderParam("Accept") String accept,
                Context context);
    }

    /**
     * Tells whether this Docker Registry instance supports Docker Registry HTTP API v2.
     *
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> checkDockerV2SupportWithResponseAsync() {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.checkDockerV2Support(this.client.getUrl(), accept, context));
    }

    /**
     * Tells whether this Docker Registry instance supports Docker Registry HTTP API v2.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> checkDockerV2SupportWithResponseAsync(Context context) {
        final String accept = "application/json";
        return service.checkDockerV2Support(this.client.getUrl(), accept, context);
    }

    /**
     * Tells whether this Docker Registry instance supports Docker Registry HTTP API v2.
     *
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> checkDockerV2SupportAsync() {
        return checkDockerV2SupportWithResponseAsync().flatMap(ignored -> Mono.empty());
    }

    /**
     * Tells whether this Docker Registry instance supports Docker Registry HTTP API v2.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> checkDockerV2SupportAsync(Context context) {
        return checkDockerV2SupportWithResponseAsync(context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Tells whether this Docker Registry instance supports Docker Registry HTTP API v2.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> checkDockerV2SupportWithResponse(Context context) {
        final String accept = "application/json";
        return service.checkDockerV2SupportSync(this.client.getUrl(), accept, context);
    }

    /**
     * Tells whether this Docker Registry instance supports Docker Registry HTTP API v2.
     *
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void checkDockerV2Support() {
        checkDockerV2SupportWithResponse(Context.NONE);
    }

    /**
     * Get the manifest identified by `name` and `reference` where `reference` can be a tag or digest.
     *
     * @param name Name of the image (including the namespace).
     * @param reference A tag or a digest, pointing to a specific image.
     * @param accept Accept header string delimited by comma. For example,
     *     application/vnd.docker.distribution.manifest.v2+json.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the manifest identified by `name` and `reference` where `reference` can be a tag or digest along with
     *     {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getManifestWithResponseAsync(String name, String reference, String accept) {
        return FluxUtil.withContext(
                context -> service.getManifest(this.client.getUrl(), name, reference, accept, context));
    }

    /**
     * Get the manifest identified by `name` and `reference` where `reference` can be a tag or digest.
     *
     * @param name Name of the image (including the namespace).
     * @param reference A tag or a digest, pointing to a specific image.
     * @param accept Accept header string delimited by comma. For example,
     *     application/vnd.docker.distribution.manifest.v2+json.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the manifest identified by `name` and `reference` where `reference` can be a tag or digest along with
     *     {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getManifestWithResponseAsync(
            String name, String reference, String accept, Context context) {
        return service.getManifest(this.client.getUrl(), name, reference, accept, context);
    }

    /**
     * Get the manifest identified by `name` and `reference` where `reference` can be a tag or digest.
     *
     * @param name Name of the image (including the namespace).
     * @param reference A tag or a digest, pointing to a specific image.
     * @param accept Accept header string delimited by comma. For example,
     *     application/vnd.docker.distribution.manifest.v2+json.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the manifest identified by `name` and `reference` where `reference` can be a tag or digest on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BinaryData> getManifestAsync(String name, String reference, String accept) {
        return getManifestWithResponseAsync(name, reference, accept).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the manifest identified by `name` and `reference` where `reference` can be a tag or digest.
     *
     * @param name Name of the image (including the namespace).
     * @param reference A tag or a digest, pointing to a specific image.
     * @param accept Accept header string delimited by comma. For example,
     *     application/vnd.docker.distribution.manifest.v2+json.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the manifest identified by `name` and `reference` where `reference` can be a tag or digest on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BinaryData> getManifestAsync(String name, String reference, String accept, Context context) {
        return getManifestWithResponseAsync(name, reference, accept, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the manifest identified by `name` and `reference` where `reference` can be a tag or digest.
     *
     * @param name Name of the image (including the namespace).
     * @param reference A tag or a digest, pointing to a specific image.
     * @param accept Accept header string delimited by comma. For example,
     *     application/vnd.docker.distribution.manifest.v2+json.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the manifest identified by `name` and `reference` where `reference` can be a tag or digest along with
     *     {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getManifestWithResponse(String name, String reference, String accept, Context context) {
        return service.getManifestSync(this.client.getUrl(), name, reference, accept, context);
    }

    /**
     * Get the manifest identified by `name` and `reference` where `reference` can be a tag or digest.
     *
     * @param name Name of the image (including the namespace).
     * @param reference A tag or a digest, pointing to a specific image.
     * @param accept Accept header string delimited by comma. For example,
     *     application/vnd.docker.distribution.manifest.v2+json.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the manifest identified by `name` and `reference` where `reference` can be a tag or digest.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BinaryData getManifest(String name, String reference, String accept) {
        return getManifestWithResponse(name, reference, accept, Context.NONE).getValue();
    }

    /**
     * Put the manifest identified by `name` and `reference` where `reference` can be a tag or digest.
     *
     * @param name Name of the image (including the namespace).
     * @param reference A tag or a digest, pointing to a specific image.
     * @param payload Manifest body, can take v1 or v2 values depending on accept header.
     * @param contentLength The Content-Length header for the request.
     * @param contentType The manifest's Content-Type.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistriesCreateManifestHeaders, Void>> createManifestWithResponseAsync(
            String name, String reference, Flux<ByteBuffer> payload, long contentLength, String contentType) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.createManifest(
                                this.client.getUrl(),
                                name,
                                reference,
                                contentType,
                                payload,
                                contentLength,
                                accept,
                                context));
    }

    /**
     * Put the manifest identified by `name` and `reference` where `reference` can be a tag or digest.
     *
     * @param name Name of the image (including the namespace).
     * @param reference A tag or a digest, pointing to a specific image.
     * @param payload Manifest body, can take v1 or v2 values depending on accept header.
     * @param contentLength The Content-Length header for the request.
     * @param contentType The manifest's Content-Type.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistriesCreateManifestHeaders, Void>> createManifestWithResponseAsync(
            String name,
            String reference,
            Flux<ByteBuffer> payload,
            long contentLength,
            String contentType,
            Context context) {
        final String accept = "application/json";
        return service.createManifest(
                this.client.getUrl(), name, reference, contentType, payload, contentLength, accept, context);
    }

    /**
     * Put the manifest identified by `name` and `reference` where `reference` can be a tag or digest.
     *
     * @param name Name of the image (including the namespace).
     * @param reference A tag or a digest, pointing to a specific image.
     * @param payload Manifest body, can take v1 or v2 values depending on accept header.
     * @param contentLength The Content-Length header for the request.
     * @param contentType The manifest's Content-Type.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createManifestAsync(
            String name, String reference, Flux<ByteBuffer> payload, long contentLength, String contentType) {
        return createManifestWithResponseAsync(name, reference, payload, contentLength, contentType)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * Put the manifest identified by `name` and `reference` where `reference` can be a tag or digest.
     *
     * @param name Name of the image (including the namespace).
     * @param reference A tag or a digest, pointing to a specific image.
     * @param payload Manifest body, can take v1 or v2 values depending on accept header.
     * @param contentLength The Content-Length header for the request.
     * @param contentType The manifest's Content-Type.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createManifestAsync(
            String name,
            String reference,
            Flux<ByteBuffer> payload,
            long contentLength,
            String contentType,
            Context context) {
        return createManifestWithResponseAsync(name, reference, payload, contentLength, contentType, context)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * Put the manifest identified by `name` and `reference` where `reference` can be a tag or digest.
     *
     * @param name Name of the image (including the namespace).
     * @param reference A tag or a digest, pointing to a specific image.
     * @param payload Manifest body, can take v1 or v2 values depending on accept header.
     * @param contentLength The Content-Length header for the request.
     * @param contentType The manifest's Content-Type.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistriesCreateManifestHeaders, Void>> createManifestWithResponseAsync(
            String name, String reference, BinaryData payload, long contentLength, String contentType) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.createManifest(
                                this.client.getUrl(),
                                name,
                                reference,
                                contentType,
                                payload,
                                contentLength,
                                accept,
                                context));
    }

    /**
     * Put the manifest identified by `name` and `reference` where `reference` can be a tag or digest.
     *
     * @param name Name of the image (including the namespace).
     * @param reference A tag or a digest, pointing to a specific image.
     * @param payload Manifest body, can take v1 or v2 values depending on accept header.
     * @param contentLength The Content-Length header for the request.
     * @param contentType The manifest's Content-Type.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ContainerRegistriesCreateManifestHeaders, Void>> createManifestWithResponseAsync(
            String name,
            String reference,
            BinaryData payload,
            long contentLength,
            String contentType,
            Context context) {
        final String accept = "application/json";
        return service.createManifest(
                this.client.getUrl(), name, reference, contentType, payload, contentLength, accept, context);
    }

    /**
     * Put the manifest identified by `name` and `reference` where `reference` can be a tag or digest.
     *
     * @param name Name of the image (including the namespace).
     * @param reference A tag or a digest, pointing to a specific image.
     * @param payload Manifest body, can take v1 or v2 values depending on accept header.
     * @param contentLength The Content-Length header for the request.
     * @param contentType The manifest's Content-Type.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createManifestAsync(
            String name, String reference, BinaryData payload, long contentLength, String contentType) {
        return createManifestWithResponseAsync(name, reference, payload, contentLength, contentType)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * Put the manifest identified by `name` and `reference` where `reference` can be a tag or digest.
     *
     * @param name Name of the image (including the namespace).
     * @param reference A tag or a digest, pointing to a specific image.
     * @param payload Manifest body, can take v1 or v2 values depending on accept header.
     * @param contentLength The Content-Length header for the request.
     * @param contentType The manifest's Content-Type.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createManifestAsync(
            String name,
            String reference,
            BinaryData payload,
            long contentLength,
            String contentType,
            Context context) {
        return createManifestWithResponseAsync(name, reference, payload, contentLength, contentType, context)
                .flatMap(ignored -> Mono.empty());
    }

    /**
     * Put the manifest identified by `name` and `reference` where `reference` can be a tag or digest.
     *
     * @param name Name of the image (including the namespace).
     * @param reference A tag or a digest, pointing to a specific image.
     * @param payload Manifest body, can take v1 or v2 values depending on accept header.
     * @param contentLength The Content-Length header for the request.
     * @param contentType The manifest's Content-Type.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ContainerRegistriesCreateManifestHeaders, Void> createManifestWithResponse(
            String name,
            String reference,
            BinaryData payload,
            long contentLength,
            String contentType,
            Context context) {
        final String accept = "application/json";
        return service.createManifestSync(
                this.client.getUrl(), name, reference, contentType, payload, contentLength, accept, context);
    }

    /**
     * Put the manifest identified by `name` and `reference` where `reference` can be a tag or digest.
     *
     * @param name Name of the image (including the namespace).
     * @param reference A tag or a digest, pointing to a specific image.
     * @param payload Manifest body, can take v1 or v2 values depending on accept header.
     * @param contentLength The Content-Length header for the request.
     * @param contentType The manifest's Content-Type.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void createManifest(
            String name, String reference, BinaryData payload, long contentLength, String contentType) {
        createManifestWithResponse(name, reference, payload, contentLength, contentType, Context.NONE);
    }

    /**
     * Delete the manifest identified by `name` and `reference`. Note that a manifest can _only_ be deleted by `digest`.
     *
     * @param name Name of the image (including the namespace).
     * @param reference Digest of a BLOB.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteManifestWithResponseAsync(String name, String reference) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context -> service.deleteManifest(this.client.getUrl(), name, reference, accept, context));
    }

    /**
     * Delete the manifest identified by `name` and `reference`. Note that a manifest can _only_ be deleted by `digest`.
     *
     * @param name Name of the image (including the namespace).
     * @param reference Digest of a BLOB.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteManifestWithResponseAsync(String name, String reference, Context context) {
        final String accept = "application/json";
        return service.deleteManifest(this.client.getUrl(), name, reference, accept, context);
    }

    /**
     * Delete the manifest identified by `name` and `reference`. Note that a manifest can _only_ be deleted by `digest`.
     *
     * @param name Name of the image (including the namespace).
     * @param reference Digest of a BLOB.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteManifestAsync(String name, String reference) {
        return deleteManifestWithResponseAsync(name, reference).flatMap(ignored -> Mono.empty());
    }

    /**
     * Delete the manifest identified by `name` and `reference`. Note that a manifest can _only_ be deleted by `digest`.
     *
     * @param name Name of the image (including the namespace).
     * @param reference Digest of a BLOB.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteManifestAsync(String name, String reference, Context context) {
        return deleteManifestWithResponseAsync(name, reference, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Delete the manifest identified by `name` and `reference`. Note that a manifest can _only_ be deleted by `digest`.
     *
     * @param name Name of the image (including the namespace).
     * @param reference Digest of a BLOB.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteManifestWithResponse(String name, String reference, Context context) {
        final String accept = "application/json";
        return service.deleteManifestSync(this.client.getUrl(), name, reference, accept, context);
    }

    /**
     * Delete the manifest identified by `name` and `reference`. Note that a manifest can _only_ be deleted by `digest`.
     *
     * @param name Name of the image (including the namespace).
     * @param reference Digest of a BLOB.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteManifest(String name, String reference) {
        deleteManifestWithResponse(name, reference, Context.NONE);
    }

    /**
     * List repositories.
     *
     * @param last Query parameter for the last item in previous query. Result set will include values lexically after
     *     last.
     * @param n query parameter for max number of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of repositories along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<String>> getRepositoriesSinglePageAsync(String last, Integer n, Context context) {
        final String accept = "application/json";
        return service.getRepositories(this.client.getUrl(), last, n, this.client.getApiVersion(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getRepositories(),
                                        res.getValue().getLink(),
                                        res.getDeserializedHeaders()));
    }

    /**
     * List repositories.
     *
     * @param last Query parameter for the last item in previous query. Result set will include values lexically after
     *     last.
     * @param n query parameter for max number of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of repositories as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> getRepositoriesAsync(String last, Integer n, Context context) {
        return new PagedFlux<>(
                () -> getRepositoriesSinglePageAsync(last, n, context),
                nextLink -> getRepositoriesNextSinglePageAsync(nextLink, context));
    }

    /**
     * List repositories.
     *
     * @param last Query parameter for the last item in previous query. Result set will include values lexically after
     *     last.
     * @param n query parameter for max number of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of repositories along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<String> getRepositoriesSinglePage(String last, Integer n, Context context) {
        final String accept = "application/json";
        ResponseBase<ContainerRegistriesGetRepositoriesHeaders, Repositories> res =
                service.getRepositoriesSync(
                        this.client.getUrl(), last, n, this.client.getApiVersion(), accept, context);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getRepositories(),
                res.getValue().getLink(),
                res.getDeserializedHeaders());
    }

    /**
     * List repositories.
     *
     * @param last Query parameter for the last item in previous query. Result set will include values lexically after
     *     last.
     * @param n query parameter for max number of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of repositories as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> getRepositories(String last, Integer n, Context context) {
        return new PagedIterable<>(
                () -> getRepositoriesSinglePage(last, n, context),
                nextLink -> getRepositoriesNextSinglePage(nextLink, context));
    }

    /**
     * Get repository attributes.
     *
     * @param name Name of the image (including the namespace).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return repository attributes along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ContainerRepositoryProperties>> getPropertiesWithResponseAsync(String name) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getProperties(
                                this.client.getUrl(), name, this.client.getApiVersion(), accept, context));
    }

    /**
     * Get repository attributes.
     *
     * @param name Name of the image (including the namespace).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return repository attributes along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ContainerRepositoryProperties>> getPropertiesWithResponseAsync(String name, Context context) {
        final String accept = "application/json";
        return service.getProperties(this.client.getUrl(), name, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get repository attributes.
     *
     * @param name Name of the image (including the namespace).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return repository attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ContainerRepositoryProperties> getPropertiesAsync(String name) {
        return getPropertiesWithResponseAsync(name).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get repository attributes.
     *
     * @param name Name of the image (including the namespace).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return repository attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ContainerRepositoryProperties> getPropertiesAsync(String name, Context context) {
        return getPropertiesWithResponseAsync(name, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get repository attributes.
     *
     * @param name Name of the image (including the namespace).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return repository attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ContainerRepositoryProperties> getPropertiesWithResponse(String name, Context context) {
        final String accept = "application/json";
        return service.getPropertiesSync(this.client.getUrl(), name, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get repository attributes.
     *
     * @param name Name of the image (including the namespace).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return repository attributes.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ContainerRepositoryProperties getProperties(String name) {
        return getPropertiesWithResponse(name, Context.NONE).getValue();
    }

    /**
     * Delete the repository identified by `name`.
     *
     * @param name Name of the image (including the namespace).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deleted repository along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeleteRepositoryResult>> deleteRepositoryWithResponseAsync(String name) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.deleteRepository(
                                this.client.getUrl(), name, this.client.getApiVersion(), accept, context));
    }

    /**
     * Delete the repository identified by `name`.
     *
     * @param name Name of the image (including the namespace).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deleted repository along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeleteRepositoryResult>> deleteRepositoryWithResponseAsync(String name, Context context) {
        final String accept = "application/json";
        return service.deleteRepository(this.client.getUrl(), name, this.client.getApiVersion(), accept, context);
    }

    /**
     * Delete the repository identified by `name`.
     *
     * @param name Name of the image (including the namespace).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deleted repository on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeleteRepositoryResult> deleteRepositoryAsync(String name) {
        return deleteRepositoryWithResponseAsync(name).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Delete the repository identified by `name`.
     *
     * @param name Name of the image (including the namespace).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deleted repository on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeleteRepositoryResult> deleteRepositoryAsync(String name, Context context) {
        return deleteRepositoryWithResponseAsync(name, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Delete the repository identified by `name`.
     *
     * @param name Name of the image (including the namespace).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deleted repository along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeleteRepositoryResult> deleteRepositoryWithResponse(String name, Context context) {
        final String accept = "application/json";
        return service.deleteRepositorySync(this.client.getUrl(), name, this.client.getApiVersion(), accept, context);
    }

    /**
     * Delete the repository identified by `name`.
     *
     * @param name Name of the image (including the namespace).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deleted repository.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeleteRepositoryResult deleteRepository(String name) {
        return deleteRepositoryWithResponse(name, Context.NONE).getValue();
    }

    /**
     * Update the attribute identified by `name` where `reference` is the name of the repository.
     *
     * @param name Name of the image (including the namespace).
     * @param value Repository attribute value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of this repository along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ContainerRepositoryProperties>> updatePropertiesWithResponseAsync(
            String name, RepositoryWriteableProperties value) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.updateProperties(
                                this.client.getUrl(), name, this.client.getApiVersion(), value, accept, context));
    }

    /**
     * Update the attribute identified by `name` where `reference` is the name of the repository.
     *
     * @param name Name of the image (including the namespace).
     * @param value Repository attribute value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of this repository along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ContainerRepositoryProperties>> updatePropertiesWithResponseAsync(
            String name, RepositoryWriteableProperties value, Context context) {
        final String accept = "application/json";
        return service.updateProperties(
                this.client.getUrl(), name, this.client.getApiVersion(), value, accept, context);
    }

    /**
     * Update the attribute identified by `name` where `reference` is the name of the repository.
     *
     * @param name Name of the image (including the namespace).
     * @param value Repository attribute value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of this repository on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ContainerRepositoryProperties> updatePropertiesAsync(String name, RepositoryWriteableProperties value) {
        return updatePropertiesWithResponseAsync(name, value).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Update the attribute identified by `name` where `reference` is the name of the repository.
     *
     * @param name Name of the image (including the namespace).
     * @param value Repository attribute value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of this repository on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ContainerRepositoryProperties> updatePropertiesAsync(
            String name, RepositoryWriteableProperties value, Context context) {
        return updatePropertiesWithResponseAsync(name, value, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Update the attribute identified by `name` where `reference` is the name of the repository.
     *
     * @param name Name of the image (including the namespace).
     * @param value Repository attribute value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of this repository along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ContainerRepositoryProperties> updatePropertiesWithResponse(
            String name, RepositoryWriteableProperties value, Context context) {
        final String accept = "application/json";
        return service.updatePropertiesSync(
                this.client.getUrl(), name, this.client.getApiVersion(), value, accept, context);
    }

    /**
     * Update the attribute identified by `name` where `reference` is the name of the repository.
     *
     * @param name Name of the image (including the namespace).
     * @param value Repository attribute value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of this repository.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ContainerRepositoryProperties updateProperties(String name, RepositoryWriteableProperties value) {
        return updatePropertiesWithResponse(name, value, Context.NONE).getValue();
    }

    /**
     * List tags of a repository.
     *
     * @param name Name of the image (including the namespace).
     * @param last Query parameter for the last item in previous query. Result set will include values lexically after
     *     last.
     * @param n query parameter for max number of items.
     * @param orderBy orderby query parameter.
     * @param digest filter by digest.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of tag details along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<TagAttributesBase>> getTagsSinglePageAsync(
            String name, String last, Integer n, String orderBy, String digest, Context context) {
        final String accept = "application/json";
        return service.getTags(
                        this.client.getUrl(),
                        name,
                        last,
                        n,
                        orderBy,
                        digest,
                        this.client.getApiVersion(),
                        accept,
                        context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getTagAttributeBases(),
                                        res.getValue().getLink(),
                                        res.getDeserializedHeaders()));
    }

    /**
     * List tags of a repository.
     *
     * @param name Name of the image (including the namespace).
     * @param last Query parameter for the last item in previous query. Result set will include values lexically after
     *     last.
     * @param n query parameter for max number of items.
     * @param orderBy orderby query parameter.
     * @param digest filter by digest.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of tag details as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<TagAttributesBase> getTagsAsync(
            String name, String last, Integer n, String orderBy, String digest, Context context) {
        return new PagedFlux<>(
                () -> getTagsSinglePageAsync(name, last, n, orderBy, digest, context),
                nextLink -> getTagsNextSinglePageAsync(nextLink, context));
    }

    /**
     * List tags of a repository.
     *
     * @param name Name of the image (including the namespace).
     * @param last Query parameter for the last item in previous query. Result set will include values lexically after
     *     last.
     * @param n query parameter for max number of items.
     * @param orderBy orderby query parameter.
     * @param digest filter by digest.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of tag details along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<TagAttributesBase> getTagsSinglePage(
            String name, String last, Integer n, String orderBy, String digest, Context context) {
        final String accept = "application/json";
        ResponseBase<ContainerRegistriesGetTagsHeaders, TagList> res =
                service.getTagsSync(
                        this.client.getUrl(),
                        name,
                        last,
                        n,
                        orderBy,
                        digest,
                        this.client.getApiVersion(),
                        accept,
                        context);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getTagAttributeBases(),
                res.getValue().getLink(),
                res.getDeserializedHeaders());
    }

    /**
     * List tags of a repository.
     *
     * @param name Name of the image (including the namespace).
     * @param last Query parameter for the last item in previous query. Result set will include values lexically after
     *     last.
     * @param n query parameter for max number of items.
     * @param orderBy orderby query parameter.
     * @param digest filter by digest.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of tag details as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<TagAttributesBase> getTags(
            String name, String last, Integer n, String orderBy, String digest, Context context) {
        return new PagedIterable<>(
                () -> getTagsSinglePage(name, last, n, orderBy, digest, context),
                nextLink -> getTagsNextSinglePage(nextLink, context));
    }

    /**
     * Get tag attributes by tag.
     *
     * @param name Name of the image (including the namespace).
     * @param reference Tag name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tag attributes by tag along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ArtifactTagPropertiesInternal>> getTagPropertiesWithResponseAsync(
            String name, String reference) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getTagProperties(
                                this.client.getUrl(), name, reference, this.client.getApiVersion(), accept, context));
    }

    /**
     * Get tag attributes by tag.
     *
     * @param name Name of the image (including the namespace).
     * @param reference Tag name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tag attributes by tag along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ArtifactTagPropertiesInternal>> getTagPropertiesWithResponseAsync(
            String name, String reference, Context context) {
        final String accept = "application/json";
        return service.getTagProperties(
                this.client.getUrl(), name, reference, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get tag attributes by tag.
     *
     * @param name Name of the image (including the namespace).
     * @param reference Tag name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tag attributes by tag on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ArtifactTagPropertiesInternal> getTagPropertiesAsync(String name, String reference) {
        return getTagPropertiesWithResponseAsync(name, reference).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get tag attributes by tag.
     *
     * @param name Name of the image (including the namespace).
     * @param reference Tag name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tag attributes by tag on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ArtifactTagPropertiesInternal> getTagPropertiesAsync(String name, String reference, Context context) {
        return getTagPropertiesWithResponseAsync(name, reference, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get tag attributes by tag.
     *
     * @param name Name of the image (including the namespace).
     * @param reference Tag name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tag attributes by tag along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ArtifactTagPropertiesInternal> getTagPropertiesWithResponse(
            String name, String reference, Context context) {
        final String accept = "application/json";
        return service.getTagPropertiesSync(
                this.client.getUrl(), name, reference, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get tag attributes by tag.
     *
     * @param name Name of the image (including the namespace).
     * @param reference Tag name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tag attributes by tag.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ArtifactTagPropertiesInternal getTagProperties(String name, String reference) {
        return getTagPropertiesWithResponse(name, reference, Context.NONE).getValue();
    }

    /**
     * Update tag attributes.
     *
     * @param name Name of the image (including the namespace).
     * @param reference Tag name.
     * @param value Tag attribute value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tag attributes along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ArtifactTagPropertiesInternal>> updateTagAttributesWithResponseAsync(
            String name, String reference, TagWriteableProperties value) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.updateTagAttributes(
                                this.client.getUrl(),
                                name,
                                reference,
                                this.client.getApiVersion(),
                                value,
                                accept,
                                context));
    }

    /**
     * Update tag attributes.
     *
     * @param name Name of the image (including the namespace).
     * @param reference Tag name.
     * @param value Tag attribute value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tag attributes along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ArtifactTagPropertiesInternal>> updateTagAttributesWithResponseAsync(
            String name, String reference, TagWriteableProperties value, Context context) {
        final String accept = "application/json";
        return service.updateTagAttributes(
                this.client.getUrl(), name, reference, this.client.getApiVersion(), value, accept, context);
    }

    /**
     * Update tag attributes.
     *
     * @param name Name of the image (including the namespace).
     * @param reference Tag name.
     * @param value Tag attribute value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tag attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ArtifactTagPropertiesInternal> updateTagAttributesAsync(
            String name, String reference, TagWriteableProperties value) {
        return updateTagAttributesWithResponseAsync(name, reference, value)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Update tag attributes.
     *
     * @param name Name of the image (including the namespace).
     * @param reference Tag name.
     * @param value Tag attribute value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tag attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ArtifactTagPropertiesInternal> updateTagAttributesAsync(
            String name, String reference, TagWriteableProperties value, Context context) {
        return updateTagAttributesWithResponseAsync(name, reference, value, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Update tag attributes.
     *
     * @param name Name of the image (including the namespace).
     * @param reference Tag name.
     * @param value Tag attribute value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tag attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ArtifactTagPropertiesInternal> updateTagAttributesWithResponse(
            String name, String reference, TagWriteableProperties value, Context context) {
        final String accept = "application/json";
        return service.updateTagAttributesSync(
                this.client.getUrl(), name, reference, this.client.getApiVersion(), value, accept, context);
    }

    /**
     * Update tag attributes.
     *
     * @param name Name of the image (including the namespace).
     * @param reference Tag name.
     * @param value Tag attribute value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tag attributes.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ArtifactTagPropertiesInternal updateTagAttributes(
            String name, String reference, TagWriteableProperties value) {
        return updateTagAttributesWithResponse(name, reference, value, Context.NONE).getValue();
    }

    /**
     * Delete tag.
     *
     * @param name Name of the image (including the namespace).
     * @param reference Tag name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTagWithResponseAsync(String name, String reference) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.deleteTag(
                                this.client.getUrl(), name, reference, this.client.getApiVersion(), accept, context));
    }

    /**
     * Delete tag.
     *
     * @param name Name of the image (including the namespace).
     * @param reference Tag name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTagWithResponseAsync(String name, String reference, Context context) {
        final String accept = "application/json";
        return service.deleteTag(this.client.getUrl(), name, reference, this.client.getApiVersion(), accept, context);
    }

    /**
     * Delete tag.
     *
     * @param name Name of the image (including the namespace).
     * @param reference Tag name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteTagAsync(String name, String reference) {
        return deleteTagWithResponseAsync(name, reference).flatMap(ignored -> Mono.empty());
    }

    /**
     * Delete tag.
     *
     * @param name Name of the image (including the namespace).
     * @param reference Tag name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteTagAsync(String name, String reference, Context context) {
        return deleteTagWithResponseAsync(name, reference, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Delete tag.
     *
     * @param name Name of the image (including the namespace).
     * @param reference Tag name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteTagWithResponse(String name, String reference, Context context) {
        final String accept = "application/json";
        return service.deleteTagSync(
                this.client.getUrl(), name, reference, this.client.getApiVersion(), accept, context);
    }

    /**
     * Delete tag.
     *
     * @param name Name of the image (including the namespace).
     * @param reference Tag name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteTag(String name, String reference) {
        deleteTagWithResponse(name, reference, Context.NONE);
    }

    /**
     * List manifests of a repository.
     *
     * @param name Name of the image (including the namespace).
     * @param last Query parameter for the last item in previous query. Result set will include values lexically after
     *     last.
     * @param n query parameter for max number of items.
     * @param orderBy orderby query parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return manifest attributes along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ManifestAttributesBase>> getManifestsSinglePageAsync(
            String name, String last, Integer n, String orderBy, Context context) {
        final String accept = "application/json";
        return service.getManifests(
                        this.client.getUrl(), name, last, n, orderBy, this.client.getApiVersion(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getManifests(),
                                        res.getValue().getLink(),
                                        res.getDeserializedHeaders()));
    }

    /**
     * List manifests of a repository.
     *
     * @param name Name of the image (including the namespace).
     * @param last Query parameter for the last item in previous query. Result set will include values lexically after
     *     last.
     * @param n query parameter for max number of items.
     * @param orderBy orderby query parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return manifest attributes as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ManifestAttributesBase> getManifestsAsync(
            String name, String last, Integer n, String orderBy, Context context) {
        return new PagedFlux<>(
                () -> getManifestsSinglePageAsync(name, last, n, orderBy, context),
                nextLink -> getManifestsNextSinglePageAsync(nextLink, context));
    }

    /**
     * List manifests of a repository.
     *
     * @param name Name of the image (including the namespace).
     * @param last Query parameter for the last item in previous query. Result set will include values lexically after
     *     last.
     * @param n query parameter for max number of items.
     * @param orderBy orderby query parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return manifest attributes along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<ManifestAttributesBase> getManifestsSinglePage(
            String name, String last, Integer n, String orderBy, Context context) {
        final String accept = "application/json";
        ResponseBase<ContainerRegistriesGetManifestsHeaders, AcrManifests> res =
                service.getManifestsSync(
                        this.client.getUrl(), name, last, n, orderBy, this.client.getApiVersion(), accept, context);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getManifests(),
                res.getValue().getLink(),
                res.getDeserializedHeaders());
    }

    /**
     * List manifests of a repository.
     *
     * @param name Name of the image (including the namespace).
     * @param last Query parameter for the last item in previous query. Result set will include values lexically after
     *     last.
     * @param n query parameter for max number of items.
     * @param orderBy orderby query parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return manifest attributes as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ManifestAttributesBase> getManifests(
            String name, String last, Integer n, String orderBy, Context context) {
        return new PagedIterable<>(
                () -> getManifestsSinglePage(name, last, n, orderBy, context),
                nextLink -> getManifestsNextSinglePage(nextLink, context));
    }

    /**
     * Get manifest attributes.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return manifest attributes along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ArtifactManifestPropertiesInternal>> getManifestPropertiesWithResponseAsync(
            String name, String digest) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getManifestProperties(
                                this.client.getUrl(), name, digest, this.client.getApiVersion(), accept, context));
    }

    /**
     * Get manifest attributes.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return manifest attributes along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ArtifactManifestPropertiesInternal>> getManifestPropertiesWithResponseAsync(
            String name, String digest, Context context) {
        final String accept = "application/json";
        return service.getManifestProperties(
                this.client.getUrl(), name, digest, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get manifest attributes.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return manifest attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ArtifactManifestPropertiesInternal> getManifestPropertiesAsync(String name, String digest) {
        return getManifestPropertiesWithResponseAsync(name, digest).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get manifest attributes.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return manifest attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ArtifactManifestPropertiesInternal> getManifestPropertiesAsync(
            String name, String digest, Context context) {
        return getManifestPropertiesWithResponseAsync(name, digest, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get manifest attributes.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return manifest attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ArtifactManifestPropertiesInternal> getManifestPropertiesWithResponse(
            String name, String digest, Context context) {
        final String accept = "application/json";
        return service.getManifestPropertiesSync(
                this.client.getUrl(), name, digest, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get manifest attributes.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return manifest attributes.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ArtifactManifestPropertiesInternal getManifestProperties(String name, String digest) {
        return getManifestPropertiesWithResponse(name, digest, Context.NONE).getValue();
    }

    /**
     * Update properties of a manifest.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param value Manifest attribute value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return manifest attributes details along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ArtifactManifestPropertiesInternal>> updateManifestPropertiesWithResponseAsync(
            String name, String digest, ManifestWriteableProperties value) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.updateManifestProperties(
                                this.client.getUrl(),
                                name,
                                digest,
                                this.client.getApiVersion(),
                                value,
                                accept,
                                context));
    }

    /**
     * Update properties of a manifest.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param value Manifest attribute value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return manifest attributes details along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ArtifactManifestPropertiesInternal>> updateManifestPropertiesWithResponseAsync(
            String name, String digest, ManifestWriteableProperties value, Context context) {
        final String accept = "application/json";
        return service.updateManifestProperties(
                this.client.getUrl(), name, digest, this.client.getApiVersion(), value, accept, context);
    }

    /**
     * Update properties of a manifest.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param value Manifest attribute value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return manifest attributes details on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ArtifactManifestPropertiesInternal> updateManifestPropertiesAsync(
            String name, String digest, ManifestWriteableProperties value) {
        return updateManifestPropertiesWithResponseAsync(name, digest, value)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Update properties of a manifest.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param value Manifest attribute value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return manifest attributes details on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ArtifactManifestPropertiesInternal> updateManifestPropertiesAsync(
            String name, String digest, ManifestWriteableProperties value, Context context) {
        return updateManifestPropertiesWithResponseAsync(name, digest, value, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Update properties of a manifest.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param value Manifest attribute value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return manifest attributes details along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ArtifactManifestPropertiesInternal> updateManifestPropertiesWithResponse(
            String name, String digest, ManifestWriteableProperties value, Context context) {
        final String accept = "application/json";
        return service.updateManifestPropertiesSync(
                this.client.getUrl(), name, digest, this.client.getApiVersion(), value, accept, context);
    }

    /**
     * Update properties of a manifest.
     *
     * @param name Name of the image (including the namespace).
     * @param digest Digest of a BLOB.
     * @param value Manifest attribute value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return manifest attributes details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ArtifactManifestPropertiesInternal updateManifestProperties(
            String name, String digest, ManifestWriteableProperties value) {
        return updateManifestPropertiesWithResponse(name, digest, value, Context.NONE).getValue();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of repositories along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<String>> getRepositoriesNextSinglePageAsync(String nextLink, Context context) {
        final String accept = "application/json";
        return service.getRepositoriesNext(nextLink, this.client.getUrl(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getRepositories(),
                                        res.getValue().getLink(),
                                        res.getDeserializedHeaders()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of repositories along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<String> getRepositoriesNextSinglePage(String nextLink, Context context) {
        final String accept = "application/json";
        ResponseBase<ContainerRegistriesGetRepositoriesNextHeaders, Repositories> res =
                service.getRepositoriesNextSync(nextLink, this.client.getUrl(), accept, context);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getRepositories(),
                res.getValue().getLink(),
                res.getDeserializedHeaders());
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of tag details along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<TagAttributesBase>> getTagsNextSinglePageAsync(String nextLink, Context context) {
        final String accept = "application/json";
        return service.getTagsNext(nextLink, this.client.getUrl(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getTagAttributeBases(),
                                        res.getValue().getLink(),
                                        res.getDeserializedHeaders()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of tag details along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<TagAttributesBase> getTagsNextSinglePage(String nextLink, Context context) {
        final String accept = "application/json";
        ResponseBase<ContainerRegistriesGetTagsNextHeaders, TagList> res =
                service.getTagsNextSync(nextLink, this.client.getUrl(), accept, context);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getTagAttributeBases(),
                res.getValue().getLink(),
                res.getDeserializedHeaders());
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return manifest attributes along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ManifestAttributesBase>> getManifestsNextSinglePageAsync(
            String nextLink, Context context) {
        final String accept = "application/json";
        return service.getManifestsNext(nextLink, this.client.getUrl(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getManifests(),
                                        res.getValue().getLink(),
                                        res.getDeserializedHeaders()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws AcrErrorsException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return manifest attributes along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<ManifestAttributesBase> getManifestsNextSinglePage(String nextLink, Context context) {
        final String accept = "application/json";
        ResponseBase<ContainerRegistriesGetManifestsNextHeaders, AcrManifests> res =
                service.getManifestsNextSync(nextLink, this.client.getUrl(), accept, context);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getManifests(),
                res.getValue().getLink(),
                res.getDeserializedHeaders());
    }
}
