// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.containers.containerregistry.implementation.models;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpResponse;

/** Exception thrown for an invalid response with AcrErrors information. */
public final class AcrErrorsException extends HttpResponseException {
    /**
     * Initializes a new instance of the AcrErrorsException class.
     *
     * @param message the exception message or the response content if a message is not available.
     * @param response the HTTP response.
     */
    public AcrErrorsException(String message, HttpResponse response) {
        super(message, response);
    }

    /**
     * Initializes a new instance of the AcrErrorsException class.
     *
     * @param message the exception message or the response content if a message is not available.
     * @param response the HTTP response.
     * @param value the deserialized response value.
     */
    public AcrErrorsException(String message, HttpResponse response, AcrErrors value) {
        super(message, response, value);
    }

    /** {@inheritDoc} */
    @Override
    public AcrErrors getValue() {
        return (AcrErrors) super.getValue();
    }
}
