/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.implementation.models;

import com.azure.containers.containerregistry.implementation.models.JWKHeader;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class JWK
implements JsonSerializable<JWK> {
    private JWKHeader jwk;
    private String alg;

    public JWKHeader getJwk() {
        return this.jwk;
    }

    public JWK setJwk(JWKHeader jwk) {
        this.jwk = jwk;
        return this;
    }

    public String getAlg() {
        return this.alg;
    }

    public JWK setAlg(String alg) {
        this.alg = alg;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("jwk", (JsonSerializable)this.jwk);
        jsonWriter.writeStringField("alg", this.alg);
        return jsonWriter.writeEndObject();
    }

    public static JWK fromJson(JsonReader jsonReader) throws IOException {
        return (JWK)jsonReader.readObject(reader -> {
            JWK deserializedJWK = new JWK();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("jwk".equals(fieldName)) {
                    deserializedJWK.jwk = JWKHeader.fromJson(reader);
                    continue;
                }
                if ("alg".equals(fieldName)) {
                    deserializedJWK.alg = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJWK;
        });
    }
}

