/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class Platform
implements JsonSerializable<Platform> {
    private String architecture;
    private String os;
    private String osVersion;
    private List<String> osFeatures;
    private String variant;
    private List<String> features;

    public String getArchitecture() {
        return this.architecture;
    }

    public Platform setArchitecture(String architecture) {
        this.architecture = architecture;
        return this;
    }

    public String getOs() {
        return this.os;
    }

    public Platform setOs(String os) {
        this.os = os;
        return this;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public Platform setOsVersion(String osVersion) {
        this.osVersion = osVersion;
        return this;
    }

    public List<String> getOsFeatures() {
        return this.osFeatures;
    }

    public Platform setOsFeatures(List<String> osFeatures) {
        this.osFeatures = osFeatures;
        return this;
    }

    public String getVariant() {
        return this.variant;
    }

    public Platform setVariant(String variant) {
        this.variant = variant;
        return this;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public Platform setFeatures(List<String> features) {
        this.features = features;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("architecture", this.architecture);
        jsonWriter.writeStringField("os", this.os);
        jsonWriter.writeStringField("os.version", this.osVersion);
        jsonWriter.writeArrayField("os.features", this.osFeatures, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("variant", this.variant);
        jsonWriter.writeArrayField("features", this.features, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static Platform fromJson(JsonReader jsonReader) throws IOException {
        return (Platform)jsonReader.readObject(reader -> {
            Platform deserializedPlatform = new Platform();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("architecture".equals(fieldName)) {
                    deserializedPlatform.architecture = reader.getString();
                    continue;
                }
                if ("os".equals(fieldName)) {
                    deserializedPlatform.os = reader.getString();
                    continue;
                }
                if ("os.version".equals(fieldName)) {
                    deserializedPlatform.osVersion = reader.getString();
                    continue;
                }
                if ("os.features".equals(fieldName)) {
                    List osFeatures;
                    deserializedPlatform.osFeatures = osFeatures = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("variant".equals(fieldName)) {
                    deserializedPlatform.variant = reader.getString();
                    continue;
                }
                if ("features".equals(fieldName)) {
                    List features;
                    deserializedPlatform.features = features = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPlatform;
        });
    }
}

