/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry;

import com.azure.containers.containerregistry.ContainerRegistryClientBuilder;
import com.azure.containers.containerregistry.ContainerRepositoryAsync;
import com.azure.containers.containerregistry.RegistryArtifactAsync;
import com.azure.containers.containerregistry.implementation.AzureContainerRegistryImpl;
import com.azure.containers.containerregistry.implementation.ContainerRegistriesImpl;
import com.azure.containers.containerregistry.implementation.UtilsImpl;
import com.azure.containers.containerregistry.implementation.models.AcrErrorsException;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ContainerRegistryClientBuilder.class, isAsync=true)
public final class ContainerRegistryAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(ContainerRegistryAsyncClient.class);
    private final ContainerRegistriesImpl registriesImplClient;
    private final HttpPipeline httpPipeline;
    private final String endpoint;
    private final String apiVersion;

    ContainerRegistryAsyncClient(HttpPipeline httpPipeline, String endpoint, String version) {
        this.httpPipeline = httpPipeline;
        this.endpoint = endpoint;
        this.registriesImplClient = new AzureContainerRegistryImpl(httpPipeline, endpoint, version).getContainerRegistries();
        this.apiVersion = version;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRepositoryNames() {
        return new PagedFlux(pageSize -> FluxUtil.withContext(context -> this.listRepositoryNamesSinglePageAsync((Integer)pageSize, (Context)context)), (token, pageSize) -> FluxUtil.withContext(context -> this.listRepositoryNamesNextSinglePageAsync((String)token, (Context)context)));
    }

    private Mono<PagedResponse<String>> listRepositoryNamesSinglePageAsync(Integer pageSize, Context context) {
        if (pageSize != null && pageSize < 0) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'pageSize' cannot be negative."));
        }
        return this.registriesImplClient.getRepositoriesSinglePageAsync(null, pageSize, context).map(UtilsImpl::getPagedResponseWithContinuationToken).onErrorMap(AcrErrorsException.class, UtilsImpl::mapAcrErrorsException);
    }

    private Mono<PagedResponse<String>> listRepositoryNamesNextSinglePageAsync(String nextLink, Context context) {
        return this.registriesImplClient.getRepositoriesNextSinglePageAsync(nextLink, context).map(UtilsImpl::getPagedResponseWithContinuationToken).onErrorMap(AcrErrorsException.class, UtilsImpl::mapAcrErrorsException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteRepositoryWithResponse(String repositoryName) {
        return FluxUtil.withContext(context -> this.deleteRepositoryWithResponse(repositoryName, (Context)context));
    }

    private Mono<Response<Void>> deleteRepositoryWithResponse(String repositoryName, Context context) {
        if (repositoryName == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'repositoryName' cannot be null."));
        }
        if (repositoryName.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'repositoryName' cannot be empty."));
        }
        return this.registriesImplClient.deleteRepositoryWithResponseAsync(repositoryName, context).map(UtilsImpl::deleteResponseToSuccess).onErrorMap(AcrErrorsException.class, UtilsImpl::mapAcrErrorsException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteRepository(String repositoryName) {
        return FluxUtil.withContext(context -> this.deleteRepository(repositoryName, (Context)context));
    }

    private Mono<Void> deleteRepository(String repositoryName, Context context) {
        return this.deleteRepositoryWithResponse(repositoryName, context).flatMap(FluxUtil::toMono);
    }

    public ContainerRepositoryAsync getRepository(String repositoryName) {
        return new ContainerRepositoryAsync(repositoryName, this.httpPipeline, this.endpoint, this.apiVersion);
    }

    public RegistryArtifactAsync getArtifact(String repositoryName, String tagOrDigest) {
        return new RegistryArtifactAsync(repositoryName, tagOrDigest, this.httpPipeline, this.endpoint, this.apiVersion);
    }
}

