/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.implementation;

import com.azure.containers.containerregistry.models.GetManifestResult;
import com.azure.containers.containerregistry.models.ManifestMediaType;
import com.azure.containers.containerregistry.models.SetManifestResult;
import com.azure.containers.containerregistry.models.UploadRegistryBlobResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;

public final class ConstructorAccessors {
    private static final ClientLogger LOGGER = new ClientLogger(ConstructorAccessors.class);
    private static GetManifestResultConstructorAccessor getManifestAccessor;
    private static UploadRegistryBlobResultConstructorAccessor uploadBlobResultAccessor;
    private static SetManifestResultConstructorAccessor setManifestResultAccessor;

    public static void setGetManifestResultAccessor(GetManifestResultConstructorAccessor accessor) {
        getManifestAccessor = accessor;
    }

    public static void setUploadRegistryBlobResultAccessor(UploadRegistryBlobResultConstructorAccessor accessor) {
        uploadBlobResultAccessor = accessor;
    }

    public static void setSetManifestResultAccessor(SetManifestResultConstructorAccessor accessor) {
        setManifestResultAccessor = accessor;
    }

    public static GetManifestResult createGetManifestResult(String digest, ManifestMediaType mediaType, BinaryData rawData) {
        if (getManifestAccessor == null) {
            try {
                Class.forName(GetManifestResult.class.getName(), true, GetManifestResultConstructorAccessor.class.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw LOGGER.logExceptionAsError(new RuntimeException(e));
            }
        }
        assert (getManifestAccessor != null);
        return getManifestAccessor.create(digest, mediaType, rawData);
    }

    public static UploadRegistryBlobResult createUploadRegistryBlobResult(String digest, long length) {
        if (uploadBlobResultAccessor == null) {
            try {
                Class.forName(UploadRegistryBlobResult.class.getName(), true, UploadRegistryBlobResultConstructorAccessor.class.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw LOGGER.logExceptionAsError(new RuntimeException(e));
            }
        }
        assert (uploadBlobResultAccessor != null);
        return uploadBlobResultAccessor.create(digest, length);
    }

    public static SetManifestResult createSetManifestResult(String digest) {
        if (setManifestResultAccessor == null) {
            try {
                Class.forName(SetManifestResult.class.getName(), true, SetManifestResultConstructorAccessor.class.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw LOGGER.logExceptionAsError(new RuntimeException(e));
            }
        }
        assert (setManifestResultAccessor != null);
        return setManifestResultAccessor.create(digest);
    }

    public static interface GetManifestResultConstructorAccessor {
        public GetManifestResult create(String var1, ManifestMediaType var2, BinaryData var3);
    }

    public static interface UploadRegistryBlobResultConstructorAccessor {
        public UploadRegistryBlobResult create(String var1, long var2);
    }

    public static interface SetManifestResultConstructorAccessor {
        public SetManifestResult create(String var1);
    }
}

