// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.containers.containerregistry.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/** The AcrRefreshToken model. */
@Fluent
public final class AcrRefreshToken implements JsonSerializable<AcrRefreshToken> {
    /*
     * The refresh token to be used for generating access tokens
     */
    private String refreshToken;

    /** Creates an instance of AcrRefreshToken class. */
    public AcrRefreshToken() {
    }

    /**
     * Get the refreshToken property: The refresh token to be used for generating access tokens.
     *
     * @return the refreshToken value.
     */
    public String getRefreshToken() {
        return this.refreshToken;
    }

    /**
     * Set the refreshToken property: The refresh token to be used for generating access tokens.
     *
     * @param refreshToken the refreshToken value to set.
     * @return the AcrRefreshToken object itself.
     */
    public AcrRefreshToken setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("refresh_token", this.refreshToken);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcrRefreshToken from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcrRefreshToken if the JsonReader was pointing to an instance of it, or null if it was
     *     pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcrRefreshToken.
     */
    public static AcrRefreshToken fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcrRefreshToken deserializedAcrRefreshToken = new AcrRefreshToken();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("refresh_token".equals(fieldName)) {
                    deserializedAcrRefreshToken.refreshToken = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAcrRefreshToken;
        });
    }
}
