/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;

public final class ContainerRegistriesCreateManifestHeaders {
    private Long contentLength;
    private String dockerContentDigest;
    private String location;
    private static final HttpHeaderName DOCKER_CONTENT_DIGEST = HttpHeaderName.fromString((String)"Docker-Content-Digest");

    public ContainerRegistriesCreateManifestHeaders(HttpHeaders rawHeaders) {
        String contentLength = rawHeaders.getValue(HttpHeaderName.CONTENT_LENGTH);
        if (contentLength != null) {
            this.contentLength = Long.parseLong(contentLength);
        }
        this.dockerContentDigest = rawHeaders.getValue(DOCKER_CONTENT_DIGEST);
        this.location = rawHeaders.getValue(HttpHeaderName.LOCATION);
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public ContainerRegistriesCreateManifestHeaders setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getDockerContentDigest() {
        return this.dockerContentDigest;
    }

    public ContainerRegistriesCreateManifestHeaders setDockerContentDigest(String dockerContentDigest) {
        this.dockerContentDigest = dockerContentDigest;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public ContainerRegistriesCreateManifestHeaders setLocation(String location) {
        this.location = location;
        return this;
    }
}

